/*
 * Decompiled with CFR 0.152.
 */
package org.signserver.deploytools.common;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.signserver.deploytools.common.LoggerFacade;

public class ZipFileUtils {
    private final LoggerFacade log;

    public ZipFileUtils(LoggerFacade log) {
        this.log = log;
    }

    public void rewriteZipEntriesLastModifiedTimeAndPomProperties(String jar, final long time) throws IOException, URISyntaxException {
        final URI zipURI = new URI("jar:file:" + jar);
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        final String timeStamp = sdf.format(new Date(time));
        try (FileSystem fs = FileSystems.newFileSystem(zipURI, new HashMap());){
            for (Path path : fs.getRootDirectories()) {
                final LinkedList directories = new LinkedList();
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        ZipFileUtils.this.log.logDebug("Found directory: " + dir);
                        if (!dir.equals(dir.getRoot())) {
                            directories.add(dir);
                        }
                        return super.preVisitDirectory(dir, attrs);
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
                        ZipFileUtils.this.log.logDebug("Setting last modified time on file: " + file);
                        if (file.startsWith("/META-INF") && file.endsWith("pom.properties")) {
                            try {
                                Charset latin1 = Charset.forName("latin1");
                                List<String> propFileLines = Files.readAllLines(file, latin1);
                                propFileLines.set(1, "#" + timeStamp);
                                Files.write(file, propFileLines, latin1, StandardOpenOption.TRUNCATE_EXISTING);
                                ZipFileUtils.this.log.logDebug("Wrote pom.properties");
                            }
                            catch (IOException ex) {
                                ZipFileUtils.this.log.logError("Failed to set deterministic time in " + zipURI + "!" + file, ex);
                            }
                        }
                        try {
                            Files.setLastModifiedTime(file, FileTime.fromMillis(time));
                        }
                        catch (IOException ex) {
                            ZipFileUtils.this.log.logError("Failed to set deterministic time on " + zipURI + "!" + file, ex);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                Collections.reverse(directories);
                for (Path dir : directories) {
                    this.log.logDebug("Setting last modified time on directory: " + dir);
                    try {
                        Files.setLastModifiedTime(dir, FileTime.fromMillis(time));
                    }
                    catch (IOException ex) {
                        this.log.logError("Failed to set deterministic time on " + zipURI + "!" + dir, ex);
                    }
                }
            }
        }
    }

    public void copyJarWithSortedZipEntries(File srcFile, File destFile) throws IOException {
        try (JarFile src = new JarFile(srcFile);
             ZipOutputStream dst = new ZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(destFile)), StandardCharsets.UTF_8);){
            Enumeration<JarEntry> entries = src.entries();
            ArrayList<String> names = new ArrayList<String>(src.size());
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                names.add(entry.getName());
            }
            this.log.logDebug("Unsorted: " + names);
            Collections.sort(names);
            this.log.logDebug("Sorted: " + names);
            for (String name : names) {
                ZipEntry entry = src.getEntry(name);
                dst.putNextEntry(entry);
                IOUtils.copy((InputStream)src.getInputStream(entry), (OutputStream)dst);
                dst.closeEntry();
            }
        }
    }
}

