/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacpp;

import com.googlecode.javacpp.Pointer;
import java.nio.FloatBuffer;

public class FloatPointer
extends Pointer {
    public FloatPointer(float ... array) {
        this(array.length);
        this.put(array);
    }

    public FloatPointer(FloatBuffer buffer) {
        super(buffer);
        if (buffer != null && buffer.hasArray()) {
            float[] array = buffer.array();
            this.allocateArray(array.length);
            this.put(array);
            this.position(buffer.position());
        }
    }

    public FloatPointer(int size) {
        try {
            this.allocateArray(size);
        }
        catch (UnsatisfiedLinkError e) {
            throw new RuntimeException("No native JavaCPP library in memory. (Has Loader.load() been called?)", e);
        }
    }

    public FloatPointer(Pointer p) {
        super(p);
    }

    private native void allocateArray(int var1);

    public FloatPointer position(int position) {
        return (FloatPointer)super.position(position);
    }

    public FloatPointer capacity(int capacity) {
        return (FloatPointer)super.capacity(capacity);
    }

    public float get() {
        return this.get(0);
    }

    public native float get(int var1);

    public FloatPointer put(float f) {
        return this.put(0, f);
    }

    public native FloatPointer put(int var1, float var2);

    public FloatPointer get(float[] array) {
        return this.get(array, 0, array.length);
    }

    public FloatPointer put(float[] array) {
        return this.put(array, 0, array.length);
    }

    public native FloatPointer get(float[] var1, int var2, int var3);

    public native FloatPointer put(float[] var1, int var2, int var3);

    public final FloatBuffer asBuffer() {
        return this.asByteBuffer().asFloatBuffer();
    }
}

