/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacv.FFmpegFrameRecorder;
import com.googlecode.javacv.OpenCVFrameRecorder;
import com.googlecode.javacv.cpp.opencv_core;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FrameRecorder {
    public static final List<Class<? extends FrameRecorder>> list = new LinkedList<Class<? extends FrameRecorder>>();
    protected String format;
    protected int imageWidth;
    protected int imageHeight;
    protected int pixelFormat;
    protected int codecID;
    protected int bitrate;
    protected double frameRate;

    public static void init() {
        for (Class<? extends FrameRecorder> c : list) {
            try {
                c.getMethod("tryLoad", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {}
        }
    }

    public static Class<? extends FrameRecorder> getDefault() {
        for (Class<? extends FrameRecorder> c : list) {
            try {
                c.getMethod("tryLoad", new Class[0]).invoke(null, new Object[0]);
                return c;
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public static Class<? extends FrameRecorder> get(String className) throws Exception {
        className = FrameRecorder.class.getPackage().getName() + "." + className;
        try {
            return Class.forName(className).asSubclass(FrameRecorder.class);
        }
        catch (ClassNotFoundException e) {
            String className2 = className + "FrameRecorder";
            try {
                return Class.forName(className2).asSubclass(FrameRecorder.class);
            }
            catch (ClassNotFoundException ex) {
                throw new Exception("Could not get FrameRecorder class for " + className + " or " + className2, e);
            }
        }
    }

    public static FrameRecorder create(Class<? extends FrameRecorder> c, Class p, Object o, int w, int h) throws Exception {
        java.lang.Exception cause = null;
        try {
            return c.getConstructor(p, Integer.TYPE, Integer.TYPE).newInstance(o, w, h);
        }
        catch (InstantiationException ex) {
            cause = ex;
        }
        catch (IllegalAccessException ex) {
            cause = ex;
        }
        catch (IllegalArgumentException ex) {
            cause = ex;
        }
        catch (NoSuchMethodException ex) {
            cause = ex;
        }
        catch (InvocationTargetException ex) {
            cause = ex;
        }
        throw new Exception("Could not create new " + c.getSimpleName() + "(" + o + ", " + w + ", " + h + ")", cause);
    }

    public static FrameRecorder createDefault(File file, int width, int height) throws Exception {
        return FrameRecorder.create(FrameRecorder.getDefault(), File.class, file, width, height);
    }

    public static FrameRecorder createDefault(String filename, int width, int height) throws Exception {
        return FrameRecorder.create(FrameRecorder.getDefault(), String.class, filename, width, height);
    }

    public static FrameRecorder create(String className, File file, int width, int height) throws Exception {
        return FrameRecorder.create(FrameRecorder.get(className), File.class, file, width, height);
    }

    public static FrameRecorder create(String className, String filename, int width, int height) throws Exception {
        return FrameRecorder.create(FrameRecorder.get(className), String.class, filename, width, height);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public void setPixelFormat(int pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    public int getCodecID() {
        return this.codecID;
    }

    public void setCodecID(int codecID) {
        this.codecID = codecID;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(double frameRate) {
        this.frameRate = frameRate;
    }

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    public abstract void record(opencv_core.IplImage var1) throws Exception;

    public abstract void release() throws Exception;

    static {
        list.add(FFmpegFrameRecorder.class);
        list.add(OpenCVFrameRecorder.class);
    }

    public static class Exception
    extends java.lang.Exception {
        public Exception(String message) {
            super(message);
        }

        public Exception(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

