/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.Loader;
import com.googlecode.javacv.FrameGrabber;
import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_highgui;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.io.File;

public class OpenCVFrameGrabber
extends FrameGrabber {
    private static FrameGrabber.Exception loadingException = null;
    private int deviceNumber = 0;
    private String filename = null;
    private opencv_highgui.CvCapture capture = null;
    private opencv_core.IplImage return_image = null;

    public static String[] getDeviceDescriptions() throws FrameGrabber.Exception {
        OpenCVFrameGrabber.tryLoad();
        throw new UnsupportedOperationException("Device enumeration not support by OpenCV.");
    }

    public static void tryLoad() throws FrameGrabber.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(opencv_highgui.class);
        }
        catch (Throwable t) {
            loadingException = new FrameGrabber.Exception("Failed to load " + OpenCVFrameGrabber.class, t);
            throw loadingException;
        }
    }

    public OpenCVFrameGrabber(int deviceNumber) {
        this.deviceNumber = deviceNumber;
    }

    public OpenCVFrameGrabber(File file) {
        this(file.getAbsolutePath());
    }

    public OpenCVFrameGrabber(String filename) {
        this.filename = filename;
    }

    public void release() throws FrameGrabber.Exception {
        this.stop();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    public double getGamma() {
        if (this.gamma == 0.0) {
            return 2.2;
        }
        return this.gamma;
    }

    public String getFormat() {
        if (this.capture == null) {
            return super.getFormat();
        }
        int fourcc = (int)opencv_highgui.cvGetCaptureProperty(this.capture, 6);
        return "" + (char)(fourcc & 0xFF) + (char)(fourcc >> 8 & 0xFF) + (char)(fourcc >> 16 & 0xFF) + (char)(fourcc >> 24 & 0xFF);
    }

    public int getImageWidth() {
        if (this.return_image != null) {
            return this.return_image.width();
        }
        return this.capture == null ? super.getImageWidth() : (int)opencv_highgui.cvGetCaptureProperty(this.capture, 3);
    }

    public int getImageHeight() {
        if (this.return_image != null) {
            return this.return_image.height();
        }
        return this.capture == null ? super.getImageHeight() : (int)opencv_highgui.cvGetCaptureProperty(this.capture, 4);
    }

    public int getPixelFormat() {
        return this.capture == null ? super.getPixelFormat() : (int)opencv_highgui.cvGetCaptureProperty(this.capture, 16);
    }

    public double getFrameRate() {
        return this.capture == null ? super.getFrameRate() : (double)((int)opencv_highgui.cvGetCaptureProperty(this.capture, 5));
    }

    public void setImageMode(FrameGrabber.ImageMode imageMode) {
        if (imageMode != this.imageMode) {
            this.return_image = null;
        }
        super.setImageMode(imageMode);
    }

    public int getFrameNumber() {
        return this.capture == null ? super.getFrameNumber() : (int)opencv_highgui.cvGetCaptureProperty(this.capture, 1);
    }

    public void setFrameNumber(int frameNumber) throws FrameGrabber.Exception {
        if (this.capture == null) {
            super.setFrameNumber(frameNumber);
        } else if (opencv_highgui.cvSetCaptureProperty(this.capture, 1, frameNumber) == 0) {
            throw new FrameGrabber.Exception("cvSetCaptureProperty() Error: Could not set CV_CAP_PROP_POS_FRAMES to " + frameNumber + ".");
        }
    }

    public long getTimestamp() {
        return this.capture == null ? (long)super.getFrameNumber() : Math.round(opencv_highgui.cvGetCaptureProperty(this.capture, 0) * 1000.0);
    }

    public void setTimestamp(long timestamp) throws FrameGrabber.Exception {
        if (this.capture == null) {
            super.setTimestamp(timestamp);
        } else if (opencv_highgui.cvSetCaptureProperty(this.capture, 0, (double)timestamp / 1000.0) == 0) {
            throw new FrameGrabber.Exception("cvSetCaptureProperty() Error: Could not set CV_CAP_PROP_POS_MSEC to " + (double)timestamp / 1000.0 + ".");
        }
    }

    public int getLengthInFrames() {
        return this.capture == null ? super.getLengthInFrames() : (int)opencv_highgui.cvGetCaptureProperty(this.capture, 7);
    }

    public long getLengthInTime() {
        return Math.round((double)(this.getLengthInFrames() * 1000000) / this.getFrameRate());
    }

    public void start() throws FrameGrabber.Exception {
        int err;
        if (this.filename != null && this.filename.length() > 0) {
            this.capture = opencv_highgui.cvCreateFileCapture(this.filename);
            if (this.capture == null) {
                throw new FrameGrabber.Exception("cvCreateFileCapture() Error: Could not create camera capture.");
            }
        } else {
            this.capture = opencv_highgui.cvCreateCameraCapture(this.deviceNumber);
            if (this.capture == null) {
                throw new FrameGrabber.Exception("cvCreateCameraCapture() Error: Could not create camera capture.");
            }
        }
        if (this.imageWidth > 0 && opencv_highgui.cvSetCaptureProperty(this.capture, 3, this.imageWidth) == 0) {
            opencv_highgui.cvSetCaptureProperty(this.capture, 9, this.imageWidth);
        }
        if (this.imageHeight > 0 && opencv_highgui.cvSetCaptureProperty(this.capture, 4, this.imageHeight) == 0) {
            opencv_highgui.cvSetCaptureProperty(this.capture, 9, this.imageHeight);
        }
        if (this.frameRate > 0.0) {
            opencv_highgui.cvSetCaptureProperty(this.capture, 5, this.frameRate);
        }
        if (this.bpp > 0) {
            opencv_highgui.cvSetCaptureProperty(this.capture, 8, this.bpp);
        }
        opencv_highgui.cvSetCaptureProperty(this.capture, 16, this.imageMode == FrameGrabber.ImageMode.COLOR ? 1.0 : 0.0);
        int count = 0;
        while (count++ < 100 && opencv_highgui.cvGrabFrame(this.capture) != 0 && opencv_highgui.cvRetrieveFrame(this.capture) == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {}
        }
        if (!this.triggerMode && (err = opencv_highgui.cvGrabFrame(this.capture)) == 0) {
            throw new FrameGrabber.Exception("cvGrabFrame() Error: Could not grab frame. (Has start() been called?)");
        }
    }

    public void stop() throws FrameGrabber.Exception {
        if (this.capture != null) {
            opencv_highgui.cvReleaseCapture(this.capture);
            this.capture = null;
        }
    }

    public void trigger() throws FrameGrabber.Exception {
        for (int i = 0; i < this.numBuffers + 1; ++i) {
            opencv_highgui.cvQueryFrame(this.capture);
        }
        int err = opencv_highgui.cvGrabFrame(this.capture);
        if (err == 0) {
            throw new FrameGrabber.Exception("cvGrabFrame() Error: Could not grab frame. (Has start() been called?)");
        }
    }

    public opencv_core.IplImage grab() throws FrameGrabber.Exception {
        int err;
        opencv_core.IplImage image = opencv_highgui.cvRetrieveFrame(this.capture);
        if (image == null) {
            throw new FrameGrabber.Exception("cvRetrieveFrame() Error: Could not retrieve frame. (Has start() been called?)");
        }
        if (!this.triggerMode && (err = opencv_highgui.cvGrabFrame(this.capture)) == 0) {
            throw new FrameGrabber.Exception("cvGrabFrame() Error: Could not grab frame. (Has start() been called?)");
        }
        if (this.imageMode == FrameGrabber.ImageMode.GRAY && image.nChannels() > 1) {
            if (this.return_image == null) {
                this.return_image = opencv_core.IplImage.create(image.width(), image.height(), image.depth(), 1);
            }
            opencv_imgproc.cvCvtColor(image, this.return_image, 6);
        } else if (this.imageMode == FrameGrabber.ImageMode.COLOR && image.nChannels() == 1) {
            if (this.return_image == null) {
                this.return_image = opencv_core.IplImage.create(image.width(), image.height(), image.depth(), 3);
            }
            opencv_imgproc.cvCvtColor(image, this.return_image, 8);
        } else {
            this.return_image = image;
        }
        return this.return_image;
    }
}

