/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javacv;

import com.googlecode.javacpp.Pointer;
import com.googlecode.javacv.CanvasFrame;
import com.googlecode.javacv.GLCanvasFrame;
import com.googlecode.javacv.ProjectiveDevice;
import com.googlecode.javacv.cpp.opencv_core;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.beans.PropertyChangeListener;

public class ProjectorDevice
extends ProjectiveDevice {
    private Settings settings;
    private static ThreadLocal<opencv_core.CvMat> B4x3 = opencv_core.CvMat.createThreadLocal(4, 3);
    private static ThreadLocal<opencv_core.CvMat> x23x1 = opencv_core.CvMat.createThreadLocal(3, 1);
    private static ThreadLocal<opencv_core.CvMat> x34x1 = opencv_core.CvMat.createThreadLocal(4, 1);

    public ProjectorDevice(String name) {
        super(name);
    }

    public ProjectorDevice(String name, String filename) throws ProjectiveDevice.Exception {
        super(name, filename);
        this.settings.setImageWidth(this.imageWidth);
        this.settings.setImageHeight(this.imageHeight);
    }

    public ProjectorDevice(String name, opencv_core.CvFileStorage fs) throws ProjectiveDevice.Exception {
        super(name, fs);
        this.settings.setImageWidth(this.imageWidth);
        this.settings.setImageHeight(this.imageHeight);
    }

    public ProjectorDevice(Settings settings) throws ProjectiveDevice.Exception {
        super((ProjectiveDevice.Settings)((Object)settings));
    }

    public ProjectiveDevice.Settings getSettings() {
        return (ProjectiveDevice.Settings)((Object)this.settings);
    }

    public void setSettings(Settings settings) {
        this.setSettings((ProjectiveDevice.Settings)((Object)settings));
    }

    public void setSettings(ProjectiveDevice.Settings settings) {
        super.setSettings(settings);
        this.settings = settings instanceof ProjectiveDevice.CalibrationSettings ? new CalibrationSettings((ProjectiveDevice.CalibrationSettings)settings) : (settings instanceof ProjectiveDevice.CalibratedSettings ? new CalibratedSettings((ProjectiveDevice.CalibratedSettings)settings) : new SettingsImplementation(settings));
        if (this.settings.getName() == null || this.settings.getName().length() == 0) {
            this.settings.setName("Projector " + String.format("%2d", this.settings.getScreenNumber()));
        }
    }

    public CanvasFrame createCanvasFrame() throws CanvasFrame.Exception {
        if (this.settings.getScreenNumber() < 0) {
            return null;
        }
        DisplayMode d = new DisplayMode(this.settings.getImageWidth(), this.settings.getImageHeight(), this.settings.getBitDepth(), this.settings.getRefreshRate());
        CanvasFrame c = this.settings.isUseOpenGL() ? new GLCanvasFrame(this.settings.getName(), this.settings.getScreenNumber(), d, this.settings.getResponseGamma()) : new CanvasFrame(this.settings.getName(), this.settings.getScreenNumber(), d, this.settings.getResponseGamma());
        c.setLatency(this.settings.getLatency());
        Dimension size = c.getCanvasSize();
        if (size.width != this.imageWidth || size.height != this.imageHeight) {
            this.rescale(size.width, size.height);
        }
        return c;
    }

    public double getAttenuation(double x, double y, opencv_core.CvMat n, double d) {
        opencv_core.CvMat B = B4x3.get();
        opencv_core.CvMat x2 = x23x1.get();
        opencv_core.CvMat x3 = x34x1.get();
        this.getBackProjectionMatrix(n, d, B);
        x2.put(x, y, 1.0);
        opencv_core.cvMatMul(B, x2, x3);
        opencv_core.cvGEMM(this.R, this.T, -1.0, null, 0.0, x2, 1);
        x3.rows(3);
        opencv_core.cvAddWeighted(x3, 1.0 / x3.get(3), x2, -1.0, 0.0, x2);
        double distance2 = opencv_core.cvDotProduct(x2, x2);
        double distance = Math.sqrt(distance2);
        double cosangle = -Math.signum(d) * opencv_core.cvDotProduct(x2, n) / (distance * Math.sqrt(opencv_core.cvDotProduct(n, n)));
        double attenuation = cosangle / distance2;
        x3.rows(4);
        return attenuation;
    }

    public static ProjectorDevice[] read(String filename) throws ProjectiveDevice.Exception {
        opencv_core.CvFileStorage fs = opencv_core.CvFileStorage.open(filename, null, 0);
        ProjectorDevice[] devices = ProjectorDevice.read(fs);
        fs.release();
        return devices;
    }

    public static ProjectorDevice[] read(opencv_core.CvFileStorage fs) throws ProjectiveDevice.Exception {
        opencv_core.CvFileNode node = opencv_core.cvGetFileNodeByName(fs, null, "Projectors");
        opencv_core.CvSeq seq = node.data_seq();
        int count = seq.total();
        ProjectorDevice[] devices = new ProjectorDevice[count];
        for (int i = 0; i < count; ++i) {
            Pointer p = opencv_core.cvGetSeqElem(seq, i);
            if (p == null) continue;
            String name = opencv_core.cvReadString(new opencv_core.CvFileNode(p), null);
            devices[i] = new ProjectorDevice(name, fs);
        }
        return devices;
    }

    public static class CalibratedSettings
    extends ProjectiveDevice.CalibratedSettings
    implements Settings {
        SettingsImplementation si = new SettingsImplementation(){

            public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                CalibratedSettings.this.firePropertyChange(propertyName, oldValue, newValue);
            }
        };

        public CalibratedSettings() {
        }

        public CalibratedSettings(ProjectiveDevice.CalibratedSettings settings) {
            super(settings);
            if (settings instanceof CalibratedSettings) {
                this.si = new SettingsImplementation(((CalibratedSettings)settings).si);
            }
        }

        public String getName() {
            return this.si.getName();
        }

        public void setName(String name) {
            this.si.setName(name);
        }

        public double getResponseGamma() {
            return this.si.getResponseGamma();
        }

        public void setResponseGamma(double responseGamma) {
            this.si.setResponseGamma(responseGamma);
        }

        public int getScreenNumber() {
            return this.si.getScreenNumber();
        }

        public void setScreenNumber(int screenNumber) {
            this.si.setScreenNumber(screenNumber);
        }

        public long getLatency() {
            return this.si.getLatency();
        }

        public void setLatency(long latency) {
            this.si.setLatency(latency);
        }

        public String getDescription() {
            return this.si.getDescription();
        }

        public int getImageWidth() {
            return this.si.getImageWidth();
        }

        public void setImageWidth(int imageWidth) {
            this.si.setImageWidth(imageWidth);
        }

        public int getImageHeight() {
            return this.si.getImageHeight();
        }

        public void setImageHeight(int imageHeight) {
            this.si.setImageHeight(imageHeight);
        }

        public int getBitDepth() {
            return this.si.getBitDepth();
        }

        public void setBitDepth(int bitDepth) {
            this.si.setBitDepth(bitDepth);
        }

        public int getRefreshRate() {
            return this.si.getRefreshRate();
        }

        public void setRefreshRate(int refreshRate) {
            this.si.setRefreshRate(refreshRate);
        }

        public boolean isUseOpenGL() {
            return this.si.isUseOpenGL();
        }

        public void setUseOpenGL(boolean useOpenGL) {
            this.si.setUseOpenGL(useOpenGL);
        }
    }

    public static class CalibrationSettings
    extends ProjectiveDevice.CalibrationSettings
    implements Settings {
        SettingsImplementation si = new SettingsImplementation(){

            public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                CalibrationSettings.this.firePropertyChange(propertyName, oldValue, newValue);
            }
        };
        double brightnessBackground = 0.0;
        double brightnessForeground = 1.0;

        public CalibrationSettings() {
        }

        public CalibrationSettings(ProjectiveDevice.CalibrationSettings settings) {
            super(settings);
            if (settings instanceof CalibrationSettings) {
                CalibrationSettings s = (CalibrationSettings)settings;
                this.si = new SettingsImplementation(s.si);
                this.brightnessBackground = s.brightnessBackground;
                this.brightnessForeground = s.brightnessForeground;
            }
        }

        public String getName() {
            return this.si.getName();
        }

        public void setName(String name) {
            this.si.setName(name);
        }

        public double getResponseGamma() {
            return this.si.getResponseGamma();
        }

        public void setResponseGamma(double responseGamma) {
            this.si.setResponseGamma(responseGamma);
        }

        public int getScreenNumber() {
            return this.si.getScreenNumber();
        }

        public void setScreenNumber(int screenNumber) {
            this.si.setScreenNumber(screenNumber);
        }

        public long getLatency() {
            return this.si.getLatency();
        }

        public void setLatency(long latency) {
            this.si.setLatency(latency);
        }

        public String getDescription() {
            return this.si.getDescription();
        }

        public int getImageWidth() {
            return this.si.getImageWidth();
        }

        public void setImageWidth(int imageWidth) {
            this.si.setImageWidth(imageWidth);
        }

        public int getImageHeight() {
            return this.si.getImageHeight();
        }

        public void setImageHeight(int imageHeight) {
            this.si.setImageHeight(imageHeight);
        }

        public int getBitDepth() {
            return this.si.getBitDepth();
        }

        public void setBitDepth(int bitDepth) {
            this.si.setBitDepth(bitDepth);
        }

        public int getRefreshRate() {
            return this.si.getRefreshRate();
        }

        public void setRefreshRate(int refreshRate) {
            this.si.setRefreshRate(refreshRate);
        }

        public boolean isUseOpenGL() {
            return this.si.isUseOpenGL();
        }

        public void setUseOpenGL(boolean useOpenGL) {
            this.si.setUseOpenGL(useOpenGL);
        }

        public double getBrightnessBackground() {
            return this.brightnessBackground;
        }

        public void setBrightnessBackground(double brightnessBackground) {
            this.brightnessBackground = brightnessBackground;
            this.firePropertyChange("brightnessBackground", this.brightnessBackground, this.brightnessBackground);
        }

        public double getBrightnessForeground() {
            return this.brightnessForeground;
        }

        public void setBrightnessForeground(double brightnessForeground) {
            this.brightnessForeground = brightnessForeground;
            this.firePropertyChange("brightnessForeground", this.brightnessForeground, this.brightnessForeground);
        }
    }

    public static class SettingsImplementation
    extends ProjectiveDevice.Settings
    implements Settings {
        int screenNumber = CanvasFrame.getScreenDevices().length > 1 ? 1 : 0;
        long latency = 200L;
        int imageWidth = 0;
        int imageHeight = 0;
        int bitDepth = 0;
        int refreshRate = 0;
        private boolean useOpenGL = false;

        public SettingsImplementation() {
            this.name = "Projector  0";
            this.setScreenNumber(this.screenNumber);
        }

        public SettingsImplementation(ProjectiveDevice.Settings settings) {
            super(settings);
            if (settings instanceof SettingsImplementation) {
                SettingsImplementation s = (SettingsImplementation)settings;
                this.screenNumber = s.screenNumber;
                this.latency = s.latency;
                this.imageWidth = s.imageWidth;
                this.imageHeight = s.imageHeight;
                this.bitDepth = s.bitDepth;
                this.refreshRate = s.refreshRate;
                this.useOpenGL = s.useOpenGL;
            }
        }

        public int getScreenNumber() {
            return this.screenNumber;
        }

        public void setScreenNumber(int screenNumber) {
            DisplayMode d = CanvasFrame.getDisplayMode(screenNumber);
            String oldDescription = this.getDescription();
            this.screenNumber = screenNumber;
            this.firePropertyChange("screenNumber", this.screenNumber, this.screenNumber);
            this.firePropertyChange("description", oldDescription, this.getDescription());
            this.imageWidth = d == null ? 0 : d.getWidth();
            this.firePropertyChange("imageWidth", this.imageWidth, this.imageWidth);
            this.imageHeight = d == null ? 0 : d.getHeight();
            this.firePropertyChange("imageHeight", this.imageHeight, this.imageHeight);
            this.bitDepth = d == null ? 0 : d.getBitDepth();
            this.firePropertyChange("bitDepth", this.bitDepth, this.bitDepth);
            this.refreshRate = d == null ? 0 : d.getRefreshRate();
            this.firePropertyChange("refreshRate", this.refreshRate, this.refreshRate);
            this.responseGamma = CanvasFrame.getGamma(screenNumber);
            this.firePropertyChange("responseGamma", this.responseGamma, this.responseGamma);
        }

        public long getLatency() {
            return this.latency;
        }

        public void setLatency(long latency) {
            this.latency = latency;
        }

        public String getDescription() {
            String[] descriptions = null;
            descriptions = CanvasFrame.getScreenDescriptions();
            if (descriptions != null && this.screenNumber >= 0 && this.screenNumber < descriptions.length) {
                return descriptions[this.screenNumber];
            }
            return "";
        }

        public int getImageWidth() {
            return this.imageWidth;
        }

        public void setImageWidth(int imageWidth) {
            this.imageWidth = imageWidth;
            this.firePropertyChange("imageWidth", this.imageWidth, this.imageWidth);
        }

        public int getImageHeight() {
            return this.imageHeight;
        }

        public void setImageHeight(int imageHeight) {
            this.imageHeight = imageHeight;
            this.firePropertyChange("imageHeight", this.imageHeight, this.imageHeight);
        }

        public int getBitDepth() {
            return this.bitDepth;
        }

        public void setBitDepth(int bitDepth) {
            this.bitDepth = bitDepth;
        }

        public int getRefreshRate() {
            return this.refreshRate;
        }

        public void setRefreshRate(int refreshRate) {
            this.refreshRate = refreshRate;
        }

        public boolean isUseOpenGL() {
            return this.useOpenGL;
        }

        public void setUseOpenGL(boolean useOpenGL) {
            this.useOpenGL = useOpenGL;
        }
    }

    public static interface Settings {
        public String getName();

        public void setName(String var1);

        public double getResponseGamma();

        public void setResponseGamma(double var1);

        public int getScreenNumber();

        public void setScreenNumber(int var1);

        public long getLatency();

        public void setLatency(long var1);

        public String getDescription();

        public int getImageWidth();

        public void setImageWidth(int var1);

        public int getImageHeight();

        public void setImageHeight(int var1);

        public int getBitDepth();

        public void setBitDepth(int var1);

        public int getRefreshRate();

        public void setRefreshRate(int var1);

        public boolean isUseOpenGL();

        public void setUseOpenGL(boolean var1);

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }
}

