/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.util.PDimension;

public class PDragEventHandler
extends PDragSequenceEventHandler {
    private PNode draggedNode = null;
    private boolean moveToFrontOnPress = false;

    public PDragEventHandler() {
        this.setEventFilter(new PInputEventFilter(16));
    }

    protected PNode getDraggedNode() {
        return this.draggedNode;
    }

    protected void setDraggedNode(PNode draggedNode) {
        this.draggedNode = draggedNode;
    }

    protected boolean shouldStartDragInteraction(PInputEvent event) {
        return super.shouldStartDragInteraction(event) && event.getPickedNode() != event.getTopCamera();
    }

    protected void startDrag(PInputEvent event) {
        super.startDrag(event);
        this.draggedNode = event.getPickedNode();
        if (this.moveToFrontOnPress) {
            this.draggedNode.moveToFront();
        }
    }

    protected void drag(PInputEvent event) {
        super.drag(event);
        PDimension d = event.getDeltaRelativeTo(this.draggedNode);
        this.draggedNode.localToParent(d);
        this.draggedNode.offset(d.getWidth(), d.getHeight());
    }

    protected void endDrag(PInputEvent event) {
        super.endDrag(event);
        this.draggedNode = null;
    }

    public boolean getMoveToFrontOnPress() {
        return this.moveToFrontOnPress;
    }

    public void setMoveToFrontOnPress(boolean moveToFrontOnPress) {
        this.moveToFrontOnPress = moveToFrontOnPress;
    }
}

