/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.util.PAffineTransformException;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PAffineTransform
extends AffineTransform {
    private static final long serialVersionUID = 1L;
    private static final double[] PTS1 = new double[8];
    private static final double[] PTS2 = new double[8];

    public PAffineTransform() {
    }

    public PAffineTransform(double[] flatmatrix) {
        super(flatmatrix);
    }

    public PAffineTransform(float[] flatmatrix) {
        super(flatmatrix);
    }

    public PAffineTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        super(m00, m10, m01, m11, m02, m12);
    }

    public PAffineTransform(float m00, float m10, float m01, float m11, float m02, float m12) {
        super(m00, m10, m01, m11, m02, m12);
    }

    public PAffineTransform(AffineTransform tx) {
        super(tx);
    }

    public void scaleAboutPoint(double scale, double x, double y) {
        this.translate(x, y);
        this.scale(scale, scale);
        this.translate(-x, -y);
    }

    public double getScale() {
        PAffineTransform.PTS1[0] = 0.0;
        PAffineTransform.PTS1[1] = 0.0;
        PAffineTransform.PTS1[2] = 1.0;
        PAffineTransform.PTS1[3] = 0.0;
        this.transform(PTS1, 0, PTS2, 0, 2);
        return Point2D.distance(PTS2[0], PTS2[1], PTS2[2], PTS2[3]);
    }

    public void setScale(double scale) {
        if (scale == 0.0) {
            throw new PAffineTransformException("Can't set scale to 0", this);
        }
        this.scaleAboutPoint(scale / this.getScale(), 0.0, 0.0);
    }

    public void setOffset(double tx, double ty) {
        this.setTransform(this.getScaleX(), this.getShearY(), this.getShearX(), this.getScaleY(), tx, ty);
    }

    public double getRotation() {
        PAffineTransform.PTS1[0] = 0.0;
        PAffineTransform.PTS1[1] = 0.0;
        PAffineTransform.PTS1[2] = 1.0;
        PAffineTransform.PTS1[3] = 0.0;
        this.transform(PTS1, 0, PTS2, 0, 2);
        double dy = Math.abs(PTS2[3] - PTS2[1]);
        double l = Point2D.distance(PTS2[0], PTS2[1], PTS2[2], PTS2[3]);
        double rotation = Math.asin(dy / l);
        if (PTS2[3] - PTS2[1] > 0.0) {
            if (PTS2[2] - PTS2[0] < 0.0) {
                rotation = Math.PI - rotation;
            }
        } else {
            rotation = PTS2[2] - PTS2[0] > 0.0 ? Math.PI * 2 - rotation : (rotation += Math.PI);
        }
        return rotation;
    }

    public void setRotation(double theta) {
        this.rotate(theta - this.getRotation());
    }

    public Dimension2D transform(Dimension2D dimSrc, Dimension2D dimDst) {
        Dimension2D result = dimDst == null ? (Dimension2D)dimSrc.clone() : dimDst;
        PAffineTransform.PTS1[0] = dimSrc.getWidth();
        PAffineTransform.PTS1[1] = dimSrc.getHeight();
        this.deltaTransform(PTS1, 0, PTS2, 0, 1);
        result.setSize(PTS2[0], PTS2[1]);
        return result;
    }

    public Point2D inverseTransform(Point2D ptSrc, Point2D ptDst) {
        try {
            return super.inverseTransform(ptSrc, ptDst);
        }
        catch (NoninvertibleTransformException e) {
            throw new PAffineTransformException("Could not invert Transform", e, this);
        }
    }

    public Dimension2D inverseTransform(Dimension2D dimSrc, Dimension2D dimDst) {
        double m10;
        double m01;
        double m11;
        Dimension2D result = dimDst == null ? (Dimension2D)dimSrc.clone() : dimDst;
        double width = dimSrc.getWidth();
        double height = dimSrc.getHeight();
        double m00 = this.getScaleX();
        double det = m00 * (m11 = this.getScaleY()) - (m01 = this.getShearX()) * (m10 = this.getShearY());
        if (!(Math.abs(det) > Double.MIN_VALUE)) {
            throw new PAffineTransformException("Could not invert transform", this);
        }
        result.setSize((width * m11 - height * m01) / det, (height * m00 - width * m10) / det);
        return result;
    }

    public Rectangle2D transform(Rectangle2D rectSrc, Rectangle2D rectDst) {
        Rectangle2D result = rectDst == null ? (Rectangle2D)rectSrc.clone() : rectDst;
        if (rectSrc.isEmpty()) {
            result.setRect(rectSrc);
            if (result instanceof PBounds) {
                ((PBounds)result).reset();
            }
            return result;
        }
        switch (this.getType()) {
            case 0: {
                if (rectSrc == result) break;
                result.setRect(rectSrc);
                break;
            }
            case 1: {
                result.setRect(rectSrc.getX() + this.getTranslateX(), rectSrc.getY() + this.getTranslateY(), rectSrc.getWidth(), rectSrc.getHeight());
                break;
            }
            case 2: {
                double scale = this.getScaleX();
                result.setRect(rectSrc.getX() * scale, rectSrc.getY() * scale, rectSrc.getWidth() * scale, rectSrc.getHeight() * scale);
                break;
            }
            case 3: {
                double scale = this.getScaleX();
                result.setRect(rectSrc.getX() * scale + this.getTranslateX(), rectSrc.getY() * scale + this.getTranslateY(), rectSrc.getWidth() * scale, rectSrc.getHeight() * scale);
                break;
            }
            default: {
                double[] pts = PAffineTransform.rectToArray(rectSrc);
                this.transform(pts, 0, pts, 0, 4);
                PAffineTransform.rectFromArray(result, pts);
            }
        }
        return result;
    }

    public Rectangle2D inverseTransform(Rectangle2D rectSrc, Rectangle2D rectDst) {
        Rectangle2D result = rectDst == null ? (Rectangle2D)rectSrc.clone() : rectDst;
        if (rectSrc.isEmpty()) {
            result.setRect(rectSrc);
            if (result instanceof PBounds) {
                ((PBounds)result).reset();
            }
            return result;
        }
        switch (this.getType()) {
            case 0: {
                if (rectSrc == result) break;
                result.setRect(rectSrc);
                break;
            }
            case 1: {
                result.setRect(rectSrc.getX() - this.getTranslateX(), rectSrc.getY() - this.getTranslateY(), rectSrc.getWidth(), rectSrc.getHeight());
                break;
            }
            case 2: {
                double scale = this.getScaleX();
                if (scale == 0.0) {
                    throw new PAffineTransformException("Could not invertTransform rectangle", this);
                }
                result.setRect(rectSrc.getX() / scale, rectSrc.getY() / scale, rectSrc.getWidth() / scale, rectSrc.getHeight() / scale);
                break;
            }
            case 3: {
                double scale = this.getScaleX();
                if (scale == 0.0) {
                    throw new PAffineTransformException("Could not invertTransform rectangle", this);
                }
                result.setRect((rectSrc.getX() - this.getTranslateX()) / scale, (rectSrc.getY() - this.getTranslateY()) / scale, rectSrc.getWidth() / scale, rectSrc.getHeight() / scale);
                break;
            }
            default: {
                double[] pts = PAffineTransform.rectToArray(rectSrc);
                try {
                    this.inverseTransform(pts, 0, pts, 0, 4);
                }
                catch (NoninvertibleTransformException e) {
                    throw new PAffineTransformException("Could not invert transform", e, this);
                }
                PAffineTransform.rectFromArray(result, pts);
            }
        }
        return result;
    }

    private static double[] rectToArray(Rectangle2D aRectangle) {
        PAffineTransform.PTS1[0] = aRectangle.getX();
        PAffineTransform.PTS1[1] = aRectangle.getY();
        PAffineTransform.PTS1[2] = PTS1[0] + aRectangle.getWidth();
        PAffineTransform.PTS1[3] = PTS1[1];
        PAffineTransform.PTS1[4] = PTS1[0] + aRectangle.getWidth();
        PAffineTransform.PTS1[5] = PTS1[1] + aRectangle.getHeight();
        PAffineTransform.PTS1[6] = PTS1[0];
        PAffineTransform.PTS1[7] = PTS1[1] + aRectangle.getHeight();
        return PTS1;
    }

    private static void rectFromArray(Rectangle2D aRectangle, double[] pts) {
        double minX = pts[0];
        double minY = pts[1];
        double maxX = pts[0];
        double maxY = pts[1];
        for (int i = 1; i < 4; ++i) {
            double x = pts[2 * i];
            double y = pts[2 * i + 1];
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        aRectangle.setRect(minX, minY, maxX - minX, maxY - minY);
    }
}

