/*
 * Decompiled with CFR 0.152.
 */
package org.jnativehook;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.event.EventListenerList;
import org.jnativehook.NativeHookException;
import org.jnativehook.NativeInputEvent;
import org.jnativehook.NativeSystem;
import org.jnativehook.keyboard.NativeKeyEvent;
import org.jnativehook.keyboard.NativeKeyListener;
import org.jnativehook.mouse.NativeMouseEvent;
import org.jnativehook.mouse.NativeMouseListener;
import org.jnativehook.mouse.NativeMouseMotionListener;
import org.jnativehook.mouse.NativeMouseWheelEvent;
import org.jnativehook.mouse.NativeMouseWheelListener;

public class GlobalScreen {
    private static final GlobalScreen instance = new GlobalScreen();
    private EventListenerList eventListeners = new EventListenerList();
    private ExecutorService eventExecutor;

    private GlobalScreen() {
        GlobalScreen.loadNativeLibrary();
    }

    protected void finalize() throws Throwable {
        if (GlobalScreen.isNativeHookRegistered()) {
            GlobalScreen.unloadNativeLibrary();
        }
        super.finalize();
    }

    public static GlobalScreen getInstance() {
        return instance;
    }

    public void addNativeKeyListener(NativeKeyListener nativeKeyListener) {
        if (nativeKeyListener != null) {
            this.eventListeners.add(NativeKeyListener.class, nativeKeyListener);
        }
    }

    public void removeNativeKeyListener(NativeKeyListener nativeKeyListener) {
        if (nativeKeyListener != null) {
            this.eventListeners.remove(NativeKeyListener.class, nativeKeyListener);
        }
    }

    public void addNativeMouseListener(NativeMouseListener nativeMouseListener) {
        if (nativeMouseListener != null) {
            this.eventListeners.add(NativeMouseListener.class, nativeMouseListener);
        }
    }

    public void removeNativeMouseListener(NativeMouseListener nativeMouseListener) {
        if (nativeMouseListener != null) {
            this.eventListeners.remove(NativeMouseListener.class, nativeMouseListener);
        }
    }

    public void addNativeMouseMotionListener(NativeMouseMotionListener nativeMouseMotionListener) {
        if (nativeMouseMotionListener != null) {
            this.eventListeners.add(NativeMouseMotionListener.class, nativeMouseMotionListener);
        }
    }

    public void removeNativeMouseMotionListener(NativeMouseMotionListener nativeMouseMotionListener) {
        if (nativeMouseMotionListener != null) {
            this.eventListeners.remove(NativeMouseMotionListener.class, nativeMouseMotionListener);
        }
    }

    public void addNativeMouseWheelListener(NativeMouseWheelListener nativeMouseWheelListener) {
        if (nativeMouseWheelListener != null) {
            this.eventListeners.add(NativeMouseWheelListener.class, nativeMouseWheelListener);
        }
    }

    public void removeNativeMouseWheelListener(NativeMouseWheelListener nativeMouseWheelListener) {
        if (nativeMouseWheelListener != null) {
            this.eventListeners.remove(NativeMouseWheelListener.class, nativeMouseWheelListener);
        }
    }

    public static native void registerNativeHook() throws NativeHookException;

    public static native void unregisterNativeHook();

    public static native boolean isNativeHookRegistered();

    public final void dispatchEvent(final NativeInputEvent nativeInputEvent) {
        this.eventExecutor.execute(new Runnable(){

            public void run() {
                if (nativeInputEvent instanceof NativeKeyEvent) {
                    GlobalScreen.this.processKeyEvent((NativeKeyEvent)nativeInputEvent);
                } else if (nativeInputEvent instanceof NativeMouseWheelEvent) {
                    GlobalScreen.this.processMouseWheelEvent((NativeMouseWheelEvent)nativeInputEvent);
                } else if (nativeInputEvent instanceof NativeMouseEvent) {
                    GlobalScreen.this.processMouseEvent((NativeMouseEvent)nativeInputEvent);
                }
            }
        });
    }

    protected void processKeyEvent(NativeKeyEvent nativeKeyEvent) {
        int n = nativeKeyEvent.getID();
        EventListener[] eventListenerArray = this.eventListeners.getListeners(NativeKeyListener.class);
        block5: for (int i = 0; i < eventListenerArray.length; ++i) {
            switch (n) {
                case 2401: {
                    ((NativeKeyListener)eventListenerArray[i]).nativeKeyPressed(nativeKeyEvent);
                    continue block5;
                }
                case 2400: {
                    ((NativeKeyListener)eventListenerArray[i]).nativeKeyTyped(nativeKeyEvent);
                    continue block5;
                }
                case 2402: {
                    ((NativeKeyListener)eventListenerArray[i]).nativeKeyReleased(nativeKeyEvent);
                }
            }
        }
    }

    protected void processMouseEvent(NativeMouseEvent nativeMouseEvent) {
        int n = nativeMouseEvent.getID();
        EventListener[] eventListenerArray = n == 2503 || n == 2504 ? this.eventListeners.getListeners(NativeMouseMotionListener.class) : this.eventListeners.getListeners(NativeMouseListener.class);
        block7: for (int i = 0; i < eventListenerArray.length; ++i) {
            switch (n) {
                case 2500: {
                    ((NativeMouseListener)eventListenerArray[i]).nativeMouseClicked(nativeMouseEvent);
                    continue block7;
                }
                case 2501: {
                    ((NativeMouseListener)eventListenerArray[i]).nativeMousePressed(nativeMouseEvent);
                    continue block7;
                }
                case 2502: {
                    ((NativeMouseListener)eventListenerArray[i]).nativeMouseReleased(nativeMouseEvent);
                    continue block7;
                }
                case 2503: {
                    ((NativeMouseMotionListener)eventListenerArray[i]).nativeMouseMoved(nativeMouseEvent);
                    continue block7;
                }
                case 2504: {
                    ((NativeMouseMotionListener)eventListenerArray[i]).nativeMouseDragged(nativeMouseEvent);
                }
            }
        }
    }

    protected void processMouseWheelEvent(NativeMouseWheelEvent nativeMouseWheelEvent) {
        EventListener[] eventListenerArray = this.eventListeners.getListeners(NativeMouseWheelListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((NativeMouseWheelListener)eventListenerArray[i]).nativeMouseWheelMoved(nativeMouseWheelEvent);
        }
    }

    protected void startEventDispatcher() {
        this.eventExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("JNativeHook Native Dispatch");
                return thread;
            }
        });
    }

    protected void stopEventDispatcher() {
        if (this.eventExecutor != null) {
            this.eventExecutor.shutdownNow();
            this.eventExecutor = null;
        }
    }

    protected static void loadNativeLibrary() {
        String string = "JNativeHook";
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                int n;
                String string2 = "/org/jnativehook/lib/" + (Object)((Object)NativeSystem.getFamily()) + "/" + (Object)((Object)NativeSystem.getArchitecture()) + "/";
                String string3 = System.mapLibraryName(string);
                string3 = string3.replaceAll("\\.jnilib$", "\\.dylib");
                int n2 = string3.lastIndexOf(46);
                String string4 = string3.substring(0, n2) + '_';
                String string5 = string3.substring(n2);
                File file = File.createTempFile(string4, string5);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[4096];
                InputStream inputStream = GlobalScreen.class.getResourceAsStream(string2.toLowerCase() + string3);
                if (inputStream == null) {
                    throw new IOException("Unable to locate the native library.");
                }
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                inputStream.close();
                file.deleteOnExit();
                System.load(file.getPath());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
        }
    }

    protected static void unloadNativeLibrary() throws NativeHookException {
        GlobalScreen.unregisterNativeHook();
    }
}

