/*
 * Decompiled with CFR 0.152.
 */
package org.jnativehook;

import java.awt.Toolkit;
import java.util.EventObject;
import org.jnativehook.GlobalScreen;

public class NativeInputEvent
extends EventObject {
    private static final long serialVersionUID = -4115869356455095225L;
    private int id;
    private long when;
    private int modifiers;
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;
    public static final int BUTTON1_MASK = 16;
    public static final int BUTTON2_MASK = 32;
    public static final int BUTTON3_MASK = 64;
    public static final int BUTTON4_MASK = 128;
    public static final int BUTTON5_MASK = 256;

    public NativeInputEvent(GlobalScreen globalScreen, int n, long l, int n2) {
        super(globalScreen);
        this.id = n;
        this.when = l;
        this.modifiers = n2;
    }

    public int getID() {
        return this.id;
    }

    public long getWhen() {
        return this.when;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int n) {
        this.modifiers = n;
    }

    public static String getModifiersText(int n) {
        StringBuilder stringBuilder = new StringBuilder(255);
        if ((n & 1) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.shift", "Shift"));
            stringBuilder.append('+');
        }
        if ((n & 2) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.control", "Ctrl"));
            stringBuilder.append('+');
        }
        if ((n & 4) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.meta", "Meta"));
            stringBuilder.append('+');
        }
        if ((n & 8) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.alt", "Alt"));
            stringBuilder.append('+');
        }
        if ((n & 0x10) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.button1", "Button1"));
            stringBuilder.append('+');
        }
        if ((n & 0x20) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.button2", "Button2"));
            stringBuilder.append('+');
        }
        if ((n & 0x40) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.button3", "Button3"));
            stringBuilder.append('+');
        }
        if ((n & 0x80) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.button4", "Button4"));
            stringBuilder.append('+');
        }
        if ((n & 0x100) != 0) {
            stringBuilder.append(Toolkit.getProperty("AWT.button5", "Button5"));
            stringBuilder.append('+');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public String paramString() {
        StringBuilder stringBuilder = new StringBuilder(255);
        stringBuilder.append("id=");
        stringBuilder.append(this.getID());
        stringBuilder.append(',');
        stringBuilder.append("when=");
        stringBuilder.append(this.getWhen());
        stringBuilder.append(',');
        stringBuilder.append("mask=");
        stringBuilder.append(Integer.toBinaryString(this.getModifiers()));
        stringBuilder.append(',');
        stringBuilder.append("modifiers=");
        stringBuilder.append(NativeInputEvent.getModifiersText(this.getModifiers()));
        return stringBuilder.toString();
    }
}

