/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import com.google.common.collect.Lists;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.sikuli.api.ModelPart;
import org.sikuli.api.VisualModel;
import org.sikuli.api.VisualModelFinder;
import org.sikuli.core.draw.PiccoloImageRenderer;

class FourCornerModel
extends VisualModel {
    static final double MIN_ASPECT_RATIO = (double)0.2f;
    private ModelPart topLeft;
    private ModelPart bottomLeft;
    private ModelPart topRight;
    private ModelPart bottomRight;

    FourCornerModel() {
    }

    public static FourCornerModel learnFrom(BufferedImage trainingImage) {
        FourCornerModel model = new FourCornerModel();
        VisualModelFinder.logger.step(trainingImage, (Object)"original model image");
        BufferedImage trimmedModelImage = trainingImage;
        VisualModelFinder.logger.step(trimmedModelImage, (Object)"margin trimmed");
        int d = 12;
        int w = trimmedModelImage.getWidth();
        int h = trimmedModelImage.getHeight();
        BufferedImage s = trimmedModelImage;
        model.topLeft = new ModelPart(new Rectangle(0, 0, 12, 12), s);
        model.topRight = new ModelPart(new Rectangle(w - 12, 0, 12, 12), s);
        model.bottomRight = new ModelPart(new Rectangle(w - 12, h - 12, 12, 12), s);
        model.bottomLeft = new ModelPart(new Rectangle(0, h - 12, 12, 12), s);
        final ArrayList<ModelPart> parts = Lists.newArrayList(model.topLeft, model.topRight, model.bottomRight, model.bottomLeft);
        PiccoloImageRenderer ir = new PiccoloImageRenderer(trimmedModelImage){

            @Override
            protected void addContent(PLayer layer) {
                for (ModelPart part : parts) {
                    PPath p = PPath.createRectangle(0.0f, 0.0f, 12.0f, 12.0f);
                    p.setStrokePaint(Color.red);
                    p.setStroke(new BasicStroke(2.0f));
                    p.setOffset(part.getBounds().getLocation());
                    layer.addChild(p);
                }
            }
        };
        VisualModelFinder.logger.step(ir, (Object)"parts");
        return model;
    }

    public ModelPart getTopLeft() {
        return this.topLeft;
    }

    public ModelPart getBottomLeft() {
        return this.bottomLeft;
    }

    public ModelPart getTopRight() {
        return this.topRight;
    }

    public ModelPart getBottomRight() {
        return this.bottomRight;
    }
}

