/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.visual;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import org.sikuli.api.Location;
import org.sikuli.api.Region;
import org.sikuli.api.visual.StyleBuilder;
import org.sikuli.api.visual.element.BoxElement;
import org.sikuli.api.visual.element.CircleElement;
import org.sikuli.api.visual.element.DotElement;
import org.sikuli.api.visual.element.Element;
import org.sikuli.api.visual.element.ImageElement;
import org.sikuli.api.visual.element.LabelElement;

public abstract class Canvas {
    private final List<Element> elements = Lists.newArrayList();

    public StyleBuilder addCircle(Location screenLocation, int radius) {
        CircleElement newElement = new CircleElement();
        newElement.x = screenLocation.getX() - radius;
        newElement.y = screenLocation.getY() - radius;
        newElement.width = 2 * radius;
        newElement.height = 2 * radius;
        return this.addElement(newElement);
    }

    public StyleBuilder addDot(Location screenLocation) {
        DotElement newElement = new DotElement();
        newElement.x = screenLocation.getX();
        newElement.y = screenLocation.getY();
        newElement.width = 0;
        newElement.height = 0;
        return this.addElement(newElement);
    }

    public StyleBuilder addImage(Location screenLocation, BufferedImage image) {
        ImageElement newElement = new ImageElement();
        newElement.x = screenLocation.getX();
        newElement.y = screenLocation.getY();
        newElement.image = image;
        return this.addElement(newElement);
    }

    public StyleBuilder addBox(Region screenRegion) {
        Rectangle r = screenRegion.getBounds();
        if (r == null) {
            r = new Rectangle(0, 0, 0, 0);
        }
        BoxElement newElement = new BoxElement();
        newElement.x = r.x;
        newElement.y = r.y;
        newElement.width = r.width;
        newElement.height = r.height;
        return this.addElement(newElement);
    }

    public StyleBuilder addLabel(Region region, String labelText) {
        Rectangle r = region.getBounds();
        LabelElement newElement = new LabelElement();
        newElement.text = labelText;
        newElement.x = r.x + r.width / 2;
        newElement.y = r.y + r.height / 2;
        return this.addElement(newElement);
    }

    public StyleBuilder addLabel(Location location, String labelText) {
        LabelElement newElement = new LabelElement();
        newElement.text = labelText;
        newElement.x = location.getX();
        newElement.y = location.getY();
        return this.addElement(newElement);
    }

    private StyleBuilder addElement(Element element) {
        this.getElements().add(element);
        return new StyleBuilder(this, element);
    }

    public Canvas clear() {
        this.getElements().clear();
        return this;
    }

    public void display(int seconds) {
        this.display((double)seconds);
    }

    public abstract void display(double var1);

    public abstract void displayWhile(Runnable var1);

    public abstract void show();

    public abstract void hide();

    public abstract BufferedImage createImage();

    protected List<Element> getElements() {
        return this.elements;
    }
}

