/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.visual;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PShadow;
import java.awt.BasicStroke;
import java.awt.Color;
import org.sikuli.api.visual.element.BoxElement;
import org.sikuli.api.visual.element.CircleElement;
import org.sikuli.api.visual.element.DotElement;
import org.sikuli.api.visual.element.Element;
import org.sikuli.api.visual.element.ImageElement;
import org.sikuli.api.visual.element.LabelElement;

class PNodeFactory {
    private static final Color SHADOW_PAINT = new Color(10, 10, 10, 200);

    PNodeFactory() {
    }

    public static PNode createFrom(Element element) {
        Class<?> clazz = element.getClass();
        if (clazz == LabelElement.class) {
            return PNodeFactory.createFrom((LabelElement)element);
        }
        if (clazz == BoxElement.class) {
            return PNodeFactory.createFrom((BoxElement)element);
        }
        if (clazz == CircleElement.class) {
            return PNodeFactory.createFrom((CircleElement)element);
        }
        if (clazz == ImageElement.class) {
            return PNodeFactory.createFrom((ImageElement)element);
        }
        if (clazz == DotElement.class) {
            return PNodeFactory.createFrom((DotElement)element);
        }
        return new PNode();
    }

    public static PNode createFrom(LabelElement element) {
        PText txt = new PText(element.text);
        txt.setTextPaint(Color.black);
        txt.setPaint(element.getBackgroundColor());
        txt.setTextPaint(element.getColor());
        txt.setFont(txt.getFont().deriveFont(element.getFontSize()));
        PNode labelNode = new PNode();
        labelNode.setPaint(element.getBackgroundColor());
        labelNode.addChild(txt);
        labelNode.setHeight(txt.getHeight() + 2.0);
        labelNode.setWidth(txt.getWidth() + 4.0);
        txt.setOffset(2.0, 1.0);
        PNodeFactory.applyAlignment(labelNode, element);
        return PNodeFactory.applyTransparencyAndShadow(labelNode, element);
    }

    public static PNode createFrom(DotElement element) {
        PPath p = PPath.createEllipse(0.0f, 0.0f, 4.0f, 4.0f);
        p.setStrokePaint(element.getColor());
        p.setPaint(element.getColor());
        p.setStroke(new BasicStroke(element.getLineWidth()));
        PNode foregroundNode = new PNode();
        foregroundNode.addChild(p);
        foregroundNode.setHeight(p.getHeight());
        foregroundNode.setWidth(p.getWidth());
        foregroundNode.setOffset(element.x - 2, element.y - 2);
        return PNodeFactory.applyTransparencyAndShadow(foregroundNode, element);
    }

    public static PNode createFrom(CircleElement element) {
        PPath p = PPath.createEllipse(0.0f, 0.0f, element.width, element.height);
        p.setStrokePaint(element.getLineColor());
        p.setPaint(null);
        p.setStroke(new BasicStroke(element.getLineWidth()));
        PNode foregroundNode = new PNode();
        foregroundNode.addChild(p);
        foregroundNode.setHeight(p.getHeight());
        foregroundNode.setWidth(p.getWidth());
        foregroundNode.setOffset(element.x, element.y);
        return PNodeFactory.applyTransparencyAndShadow(foregroundNode, element);
    }

    public static PNode createFrom(BoxElement element) {
        PPath p = PPath.createRectangle(0.0f, 0.0f, element.width, element.height);
        p.setStrokePaint(element.getLineColor());
        p.setPaint(null);
        p.setStroke(new BasicStroke(element.getLineWidth()));
        PNode foregroundNode = new PNode();
        foregroundNode.addChild(p);
        foregroundNode.setHeight(p.getHeight());
        foregroundNode.setWidth(p.getWidth());
        foregroundNode.setOffset(element.x, element.y);
        return PNodeFactory.applyTransparencyAndShadow(foregroundNode, element);
    }

    public static PNode createFrom(ImageElement element) {
        PImage p = new PImage(element.image);
        PNode foregroundNode = new PNode();
        foregroundNode.addChild(p);
        foregroundNode.setHeight(p.getHeight());
        foregroundNode.setWidth(p.getWidth());
        foregroundNode.setOffset(element.x, element.y);
        PNodeFactory.applyAlignment(foregroundNode, element);
        return PNodeFactory.applyTransparencyAndShadow(foregroundNode, element);
    }

    private static void applyAlignment(PNode node, Element element) {
        double width = node.getWidth();
        double height = node.getHeight();
        double x = element.x;
        double y = element.y;
        if (element.verticalAlignment == Element.VerticalAlignment.TOP) {
            y = element.y;
        } else if (element.verticalAlignment == Element.VerticalAlignment.MIDDLE) {
            y = (double)element.y - height / 2.0;
        } else if (element.verticalAlignment == Element.VerticalAlignment.BOTTOM) {
            y = (double)element.y - height;
        }
        if (element.horizontalAlignment == Element.HorizontalAlignment.RIGHT) {
            x = (double)element.x - width;
        } else if (element.horizontalAlignment == Element.HorizontalAlignment.LEFT) {
            x = element.x;
        } else if (element.horizontalAlignment == Element.HorizontalAlignment.CENTER) {
            x = (double)element.x - width / 2.0;
        }
        node.setOffset(x, y);
    }

    private static PNode applyTransparencyAndShadow(PNode node, Element element) {
        PNode shadowedNode = PNodeFactory.addShadow(node);
        shadowedNode.setTransparency(element.getTransparency());
        return shadowedNode;
    }

    private static PNode addShadow(PNode contentNode) {
        PNode contentNodeWithShadow = new PNode();
        double xoffset = contentNode.getXOffset();
        double yoffset = contentNode.getYOffset();
        int blurRadius = 4;
        int tx = 5;
        int ty = 5;
        PShadow shadowNode = new PShadow(contentNode.toImage(), SHADOW_PAINT, blurRadius);
        contentNode.setOffset(tx, ty);
        shadowNode.setOffset((double)(tx - 2 * blurRadius) + 1.0, (double)(ty - 2 * blurRadius) + 1.0);
        contentNodeWithShadow.addChild(shadowNode);
        contentNodeWithShadow.addChild(contentNode);
        contentNodeWithShadow.setOffset(xoffset - (double)tx, yoffset - (double)ty);
        contentNodeWithShadow.setBounds(0.0, 0.0, contentNode.getWidth() + (double)(2 * blurRadius) + (double)tx, contentNode.getHeight() + (double)(2 * blurRadius) + (double)ty);
        return contentNodeWithShadow;
    }
}

