/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.visual;

import com.google.common.collect.Lists;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.ListIterator;
import javax.swing.SwingUtilities;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.robot.desktop.DesktopScreen;
import org.sikuli.api.visual.Canvas;
import org.sikuli.api.visual.PNodeFactory;
import org.sikuli.api.visual.ScreenDisplayable;
import org.sikuli.api.visual.ScreenOverlayWindow;
import org.sikuli.api.visual.element.Element;
import org.sikuli.core.cv.VisionUtils;

public class ScreenRegionCanvas
extends Canvas {
    private ScreenRegion screenRegion;
    List<ScreenDisplayable> displayableList = Lists.newArrayList();

    public ScreenRegionCanvas(ScreenRegion screenRegion) {
        this.setScreenRegion(screenRegion);
    }

    @Override
    public void display(int seconds) {
        this.display((double)seconds);
    }

    @Override
    public void display(double seconds) {
        this.show();
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.hide();
    }

    @Override
    public void displayWhile(Runnable runnable) {
        this.show();
        runnable.run();
        this.hide();
    }

    @Override
    public void show() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Element element : ScreenRegionCanvas.this.getElements()) {
                    ScreenRegionCanvas.this.displayableList.add(ScreenRegionCanvas.this.createScreenDisplayable(element));
                }
                for (ScreenDisplayable d : ScreenRegionCanvas.this.displayableList) {
                    d.displayOnScreen();
                }
            }
        });
    }

    public void refresh() {
        this.hide();
        this.show();
    }

    @Override
    public void hide() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ScreenDisplayable d : ScreenRegionCanvas.this.displayableList) {
                    d.hideFromScreen();
                    ScreenOverlayWindow w = (ScreenOverlayWindow)d;
                    PCanvas canvas = w.getCanvas();
                    ScreenRegionCanvas.removeAllChildrenRecursively(canvas.getLayer());
                }
                ScreenRegionCanvas.this.displayableList.clear();
                System.gc();
            }
        });
    }

    private static void removeAllChildrenRecursively(PNode node) {
        ListIterator it = node.getChildrenIterator();
        while (it.hasNext()) {
            PNode n = (PNode)it.next();
            ScreenRegionCanvas.removeAllChildrenRecursively(n);
        }
        node.removeAllChildren();
    }

    protected ScreenDisplayable createScreenDisplayable(Element element) {
        Rectangle screenBounds = ((DesktopScreen)this.getScreenRegion().getScreen()).getBounds();
        ScreenOverlayWindow overlayWindow = new ScreenOverlayWindow();
        PNode node = PNodeFactory.createFrom(element);
        int x = (int)node.getXOffset();
        int y = (int)node.getYOffset();
        PBounds bounds = node.getBounds();
        node.setOffset(0.0, 0.0);
        overlayWindow.getCanvas().getLayer().addChild(node);
        overlayWindow.setLocation(screenBounds.x + x, screenBounds.y + y);
        overlayWindow.setSize((int)bounds.width, (int)bounds.height);
        return overlayWindow;
    }

    @Override
    public BufferedImage createImage() {
        PCanvas canvas = new PCanvas();
        BufferedImage backgroundImage = this.getScreenRegion().capture();
        PImage background = new PImage(backgroundImage);
        canvas.getLayer().addChild(background);
        canvas.setBounds(0, 0, backgroundImage.getWidth(), backgroundImage.getHeight());
        PLayer layer = canvas.getLayer();
        Rectangle r = this.getScreenRegion().getBounds();
        PLayer foregroundLayer = new PLayer();
        layer.addChild(foregroundLayer);
        foregroundLayer.setGlobalTranslation(new Point(-r.x, -r.y));
        layer.addChild(foregroundLayer);
        for (Element element : this.getElements()) {
            PNode node = PNodeFactory.createFrom(element);
            foregroundLayer.addChild(node);
        }
        return VisionUtils.createComponentImage(canvas);
    }

    public ScreenRegion getScreenRegion() {
        return this.screenRegion;
    }

    public void setScreenRegion(ScreenRegion screenRegion) {
        this.screenRegion = screenRegion;
    }
}

