/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.visual;

import java.awt.Color;
import org.sikuli.api.visual.Canvas;
import org.sikuli.api.visual.element.Element;

public class StyleBuilder {
    private final Element element;
    private final Canvas canvas;

    public StyleBuilder(Canvas canvas, Element element) {
        this.element = element;
        this.canvas = canvas;
    }

    public StyleBuilder withLineColor(Color color) {
        this.element.setLineColor(color);
        return this;
    }

    public StyleBuilder withColor(Color color) {
        this.element.setColor(color);
        return this;
    }

    public StyleBuilder withBackgroundColor(Color color) {
        this.element.setBackgroundColor(color);
        return this;
    }

    public StyleBuilder withTransparency(float f) {
        this.element.setTransparency(f);
        return this;
    }

    public StyleBuilder withFontSize(int size) {
        this.element.setFontSize(size);
        return this;
    }

    public StyleBuilder withLineWidth(int width) {
        this.element.setLineWidth(width);
        return this;
    }

    public StyleBuilder withVerticalAlignmentMiddle() {
        this.element.verticalAlignment = Element.VerticalAlignment.MIDDLE;
        return this;
    }

    public StyleBuilder withVerticalAlignmentTop() {
        this.element.verticalAlignment = Element.VerticalAlignment.TOP;
        return this;
    }

    public StyleBuilder withVerticalAlignmentBottom() {
        this.element.verticalAlignment = Element.VerticalAlignment.BOTTOM;
        return this;
    }

    public StyleBuilder withHorizontalAlignmentLeft() {
        this.element.horizontalAlignment = Element.HorizontalAlignment.LEFT;
        return this;
    }

    public StyleBuilder withHorizontalAlignmentCenter() {
        this.element.horizontalAlignment = Element.HorizontalAlignment.CENTER;
        return this;
    }

    public StyleBuilder withHorizontalAlignmentRight() {
        this.element.horizontalAlignment = Element.HorizontalAlignment.RIGHT;
        return this;
    }

    public void display(int seconds) {
        this.canvas.display(seconds);
    }

    public void display(double seconds) {
        this.canvas.display(seconds);
    }
}

