/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.awt.image.BufferedImage;
import org.sikuli.core.cv.FindResult;

class BaseTemplateFinder {
    BaseTemplateFinder() {
    }

    public static opencv_core.IplImage computeTemplateMatchResultMatrix(opencv_core.IplImage input, opencv_core.IplImage target) {
        int iheight;
        int iwidth;
        if (input.roi() != null) {
            iwidth = input.roi().width() - target.width() + 1;
            iheight = input.roi().height() - target.height() + 1;
        } else {
            iwidth = input.width() - target.width() + 1;
            iheight = input.height() - target.height() + 1;
        }
        opencv_core.IplImage map = opencv_core.IplImage.create(opencv_core.cvSize(iwidth, iheight), 32, 1);
        opencv_imgproc.cvMatchTemplate(input, target, map, 5);
        return map;
    }

    static FindResult findGroundTruthTopMatch(BufferedImage screenImage, BufferedImage targetImage, double min_similarity) {
        opencv_core.IplImage inputColor = opencv_core.IplImage.createFrom(screenImage);
        opencv_core.IplImage targetColor = opencv_core.IplImage.createFrom(targetImage);
        opencv_core.IplImage inputGray = opencv_core.IplImage.create(opencv_core.cvGetSize(inputColor), 8, 1);
        opencv_core.IplImage targetGray = opencv_core.IplImage.create(opencv_core.cvGetSize(targetColor), 8, 1);
        opencv_imgproc.cvCvtColor(inputColor, inputGray, 7);
        opencv_imgproc.cvCvtColor(targetColor, targetGray, 7);
        opencv_core.IplImage map = BaseTemplateFinder.computeTemplateMatchResultMatrix(inputGray, targetGray);
        double[] min = new double[1];
        double[] max = new double[1];
        opencv_core.CvPoint minPoint = new opencv_core.CvPoint(2);
        opencv_core.CvPoint maxPoint = new opencv_core.CvPoint(2);
        opencv_core.cvMinMaxLoc((opencv_core.CvArr)map, min, max, minPoint, maxPoint, null);
        opencv_core.cvReleaseImage(map);
        opencv_core.cvReleaseImage(inputColor);
        opencv_core.cvReleaseImage(targetColor);
        opencv_core.cvReleaseImage(inputGray);
        opencv_core.cvReleaseImage(targetColor);
        FindResult result = new FindResult();
        result.x = maxPoint.x();
        result.y = maxPoint.y();
        result.width = targetImage.getWidth();
        result.height = targetImage.getHeight();
        result.score = max[0];
        return result;
    }
}

