/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.googlecode.javacv.cpp.opencv_core;
import java.awt.image.BufferedImage;

public class ImageMask {
    private opencv_core.IplImage mask;

    private ImageMask() {
    }

    public void add(int x, int y, int width, int height) {
        opencv_core.cvSetImageROI(this.mask, opencv_core.cvRect(x, y, width, height));
        opencv_core.cvSet(this.mask, opencv_core.cvScalarAll(255.0));
        opencv_core.cvResetImageROI(this.mask);
    }

    public void remove(int x, int y, int width, int height) {
        opencv_core.cvSetImageROI(this.mask, opencv_core.cvRect(x, y, width, height));
        opencv_core.cvSet(this.mask, opencv_core.cvScalarAll(0.0));
        opencv_core.cvResetImageROI(this.mask);
    }

    public static ImageMask create(int w, int h) {
        ImageMask m = new ImageMask();
        m.mask = opencv_core.IplImage.create(opencv_core.cvSize(w, h), 8, 1);
        return m;
    }

    public static ImageMask createFrom(opencv_core.IplImage image) {
        return ImageMask.create(image.width(), image.height());
    }

    public static ImageMask createFrom(BufferedImage image) {
        return ImageMask.create(image.getWidth(), image.getHeight());
    }

    public BufferedImage createMaskedImage(BufferedImage input) {
        opencv_core.IplImage image = opencv_core.IplImage.createFrom(input);
        opencv_core.IplImage maskedImage = opencv_core.IplImage.createCompatible(image);
        opencv_core.cvSet(maskedImage, opencv_core.cvScalarAll(0.0), null);
        opencv_core.cvCopy(image, maskedImage, this.mask);
        return maskedImage.getBufferedImage();
    }
}

