/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.googlecode.javacv.cpp.opencv_core;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.sikuli.core.cv.MarginFinderOld;
import org.sikuli.core.draw.ImageRenderer;
import org.sikuli.core.draw.PiccoloImageRenderer;
import org.sikuli.core.logging.ImageExplainer;

public class Space {
    private static ImageExplainer logger = ImageExplainer.getExplainer(MarginFinderOld.class);
    private opencv_core.IplImage gray;

    public Space(opencv_core.IplImage gray) {
        this.gray = gray;
    }

    public Rectangle findContentBounds(Rectangle roi) {
        int h = this.gray.height();
        int w = this.gray.width();
        int t = Space.findMarginEndPosition(this.gray, roi.y, roi.y + roi.height, 1, true, roi);
        int b = Space.findMarginEndPosition(this.gray, roi.y + roi.height - 1, roi.y, -1, true, roi);
        int l = Space.findMarginEndPosition(this.gray, roi.x, roi.x + roi.width, 1, false, roi);
        int r = Space.findMarginEndPosition(this.gray, roi.x + roi.width - 1, roi.x, -1, false, roi);
        if (r < l) {
            l = r;
        }
        if (b < t) {
            b = t;
        }
        Rectangle regionInsideMargin = new Rectangle(l, t, r - l + 1, b - t + 1);
        ExplainationImageRenderer explainationImageRenderer = new ExplainationImageRenderer(this.gray.getBufferedImage(), regionInsideMargin);
        logger.result(explainationImageRenderer, (Object)("margin (t=" + t + ", l=" + l + ", b=" + b + ", r=" + r + ")"));
        return regionInsideMargin;
    }

    private static int findMarginEndPosition(opencv_core.IplImage gray, int startPosition, int endPosition, int step, boolean row, Rectangle roi) {
        int h = gray.height();
        int w = gray.width();
        int i = startPosition;
        while (i + step != endPosition) {
            if (row) {
                opencv_core.CvRect rowROI = opencv_core.cvRect(roi.x, i, roi.width, 1);
                opencv_core.cvSetImageROI(gray, rowROI);
            } else {
                opencv_core.CvRect colROI = opencv_core.cvRect(i, roi.y, 1, roi.height - 1);
                opencv_core.cvSetImageROI(gray, colROI);
            }
            opencv_core.CvScalar mean = new opencv_core.CvScalar();
            opencv_core.CvScalar stdDev = new opencv_core.CvScalar();
            opencv_core.cvAvgSdv(gray, mean, stdDev, null);
            opencv_core.cvResetImageROI(gray);
            if (stdDev.getVal(0) > 10.0) {
                return i;
            }
            i += step;
        }
        return endPosition;
    }

    static class ExplainationImageRenderer
    extends PiccoloImageRenderer
    implements ImageRenderer {
        private final Rectangle r;

        public ExplainationImageRenderer(BufferedImage input, Rectangle r) {
            super(input);
            this.r = r;
        }

        @Override
        protected void addContent(PLayer layer) {
            PPath p = PPath.createRectangle(this.r.x, this.r.y, this.r.width, this.r.height);
            p.setPaint(null);
            p.setStrokePaint(Color.red);
            p.setStroke(new BasicStroke(1.0f));
            layer.addChild(p);
        }
    }
}

