/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.logging;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.sikuli.core.logging.Appender;
import org.sikuli.core.logging.ImageExplanation;

class DefaultAppender
implements Appender {
    private static final int MIN_CANVAS_HEIGHT = 30;
    private static final int MIN_CANVAS_WIDTH = 400;
    private int counter = 0;
    private static final String DefaultOutputDirectory = "log";

    DefaultAppender() {
    }

    private static File getOutputDirectory() {
        File outputDir = new File(DefaultOutputDirectory);
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        return outputDir;
    }

    public static BufferedImage createComponentImage(Component component) {
        Dimension size = component.getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics2D g2 = image.createGraphics();
        component.paint(g2);
        g2.dispose();
        return image;
    }

    static BufferedImage paintMessageOnImage(BufferedImage input, Object message) {
        PCanvas canvas = new PCanvas();
        PText text = new PText(message.toString());
        text.setOffset(0.0, 0.0);
        text.setPaint(Color.white);
        text.setTextPaint(Color.black);
        text.setTransparency(0.9f);
        PImage image = new PImage(input);
        image.setOffset(0.0, 30.0);
        PPath imageBorder = PPath.createRectangle(0.0f, 30.0f, (int)image.getWidth() - 1, (int)image.getHeight() - 1);
        imageBorder.setPaint(null);
        imageBorder.setStrokePaint(Color.black);
        imageBorder.setStroke(new BasicStroke(1.0f));
        canvas.getLayer().addChild(image);
        canvas.getLayer().addChild(text);
        canvas.getLayer().addChild(imageBorder);
        int w = Math.max(400, input.getWidth());
        int h = Math.max(30, input.getHeight() + 30);
        canvas.setBounds(0, 0, w, h);
        return DefaultAppender.createComponentImage(canvas);
    }

    @Override
    public void doAppend(ImageExplanation event) {
        String filename = "explain." + event.logger.getName() + "." + this.counter + ".png";
        try {
            BufferedImage imageWithMessage = DefaultAppender.paintMessageOnImage(event.image, event.message);
            File imageFile = new File(DefaultAppender.getOutputDirectory(), filename);
            ImageIO.write((RenderedImage)imageWithMessage, "png", imageFile);
            event.imageLocalPath = filename;
            event.image = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ++this.counter;
    }
}

