/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.logging;

import com.googlecode.javacv.cpp.opencv_core;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.sikuli.core.draw.ImageRenderer;
import org.sikuli.core.logging.Appender;
import org.sikuli.core.logging.DefaultAppender;
import org.sikuli.core.logging.ImageExplanation;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

public class ImageExplainer {
    private final Appender appender = new DefaultAppender();
    private final String name;
    private Level level = Level.OFF;
    private int counter = 0;
    private List<ImageLogRecord> records = new ArrayList<ImageLogRecord>();
    @Deprecated
    private static boolean isEnabled = false;
    private static int count;
    static final Map<String, ImageExplainer> explainers;

    public ImageExplainer(String name) {
        this.name = name;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void writeLogReportAsHTML() throws IOException {
        STGroupFile g = new STGroupFile("org/sikuli/core/cv/logger.stg", "utf-8", '$', '$');
        ArrayList<ST> sts = new ArrayList<ST>();
        for (ImageLogRecord record : this.records) {
            ST st = g.getInstanceOf("image_log_record");
            st.add("title", record.title);
            st.add("image_filename", record.image_filename);
            st.add("description", record.description);
            sts.add(st);
        }
        ST reportST = g.getInstanceOf("report");
        reportST.add("records", sts);
        BufferedWriter out = new BufferedWriter(new FileWriter(this.getName() + ".html"));
        out.write(reportST.render());
        out.flush();
    }

    public void result(opencv_core.IplImage image, Object message) {
        this.result(image.getBufferedImage(), message);
    }

    public void step(ImageRenderer producer, Object message) {
        if (this.level.isGreaterOrEqual(Level.STEP)) {
            this.step(producer.render(), message);
        }
    }

    public void result(ImageRenderer producer, Object message) {
        if (this.level.isGreaterOrEqual(Level.RESULT)) {
            this.result(producer.render(), message);
        }
    }

    public void step(opencv_core.IplImage image, Object message) {
        this.step(image.getBufferedImage(), message);
    }

    public void step(BufferedImage image, Object message) {
        if (this.level.isGreaterOrEqual(Level.STEP)) {
            ImageExplanation event = new ImageExplanation();
            event.level = Level.STEP;
            event.logger = this;
            event.message = message;
            event.timestamp = new Date().getTime();
            event.image = image;
            this.appender.doAppend(event);
        }
    }

    public void result(BufferedImage image, Object message) {
        if (this.level.isGreaterOrEqual(Level.RESULT)) {
            ImageExplanation event = new ImageExplanation();
            event.level = Level.RESULT;
            event.logger = this;
            event.message = message;
            event.timestamp = new Date().getTime();
            event.image = image;
            this.appender.doAppend(event);
        }
    }

    @Deprecated
    public void log(String title, opencv_core.IplImage image) {
        this.log(title, image.getBufferedImage());
    }

    @Deprecated
    public void log(String title, BufferedImage image) {
        String filename = "vlog." + this.getName() + "." + this.counter + "." + title + ".png";
        try {
            ImageIO.write((RenderedImage)image, "png", new File(filename));
        }
        catch (IOException e) {
            // empty catch block
        }
        ImageExplanation event = new ImageExplanation();
        event.logger = this;
        event.message = title;
        event.timestamp = new Date().getTime();
        event.imageLocalPath = filename;
        this.appender.doAppend(event);
    }

    @Deprecated
    public void log(String title, BufferedImage image, String description) {
        String filename = "vlog." + this.getName() + "." + this.counter + "." + title + ".png";
        ++this.counter;
        try {
            ImageIO.write((RenderedImage)image, "png", new File(filename));
            ImageLogRecord r = new ImageLogRecord();
            r.title = title;
            r.image_filename = filename;
            r.description = description;
            this.records.add(r);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Deprecated
    public static void setEnabledGlobal(boolean enabled) {
        isEnabled = enabled;
    }

    @Deprecated
    public static void vlog(String title, BufferedImage image) {
        if (!isEnabled) {
            return;
        }
        String name = "vlog." + count + "." + title + ".png";
        try {
            ImageIO.write((RenderedImage)image, "png", new File(name));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ++count;
    }

    public String getName() {
        return this.name;
    }

    public static ImageExplainer getExplainer(Class clazz) {
        return ImageExplainer.getExplainer(clazz.getCanonicalName());
    }

    public static ImageExplainer getExplainer(String name) {
        ImageExplainer explainer;
        if (explainers.containsKey(name)) {
            explainer = explainers.get(name);
        } else {
            explainer = new ImageExplainer(name);
            explainers.put(name, explainer);
        }
        return explainer;
    }

    static {
        explainers = new HashMap<String, ImageExplainer>();
    }

    class ImageLogRecord {
        String title = "";
        String image_filename = "";
        String description = "";

        ImageLogRecord() {
        }
    }

    public static class Level {
        static final int ALL_INT = 100;
        static final int STEP_INT = 2;
        static final int RESULT_INT = 1;
        static final int OFF_INT = 0;
        private final int levelInt;
        private final String levelString;
        public static Level ALL = new Level(100, "ALL");
        public static Level STEP = new Level(2, "STEP");
        public static Level RESULT = new Level(1, "RESULT");
        public static Level OFF = new Level(0, "OFF");

        Level(int level, String levelString) {
            this.levelInt = level;
            this.levelString = levelString;
        }

        public boolean isGreaterOrEqual(Level anotherLevel) {
            return this.levelInt >= anotherLevel.levelInt;
        }
    }
}

