/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.search;

import com.google.common.collect.Lists;
import com.googlecode.javacv.cpp.opencv_core;
import java.awt.image.BufferedImage;
import java.util.List;
import org.sikuli.core.cv.ImagePreprocessor;
import org.sikuli.core.logging.ImageExplainer;
import org.sikuli.core.search.ImageQuery;
import org.sikuli.core.search.ImageSearcher;
import org.sikuli.core.search.RegionMatch;
import org.sikuli.core.search.SearchAlgorithm;
import org.sikuli.core.search.SearchAlgorithmFactory;

public class MaskedImageQuery
extends ImageQuery {
    private static final ImageExplainer logger = ImageExplainer.getExplainer(MaskedImageQuery.class);
    private final List<BufferedImage> subimagesToIgnore = Lists.newArrayList();

    public MaskedImageQuery(BufferedImage queryImage) {
        super(queryImage);
    }

    public void ignore(BufferedImage subimageToIgnore) {
        this.subimagesToIgnore.add(subimageToIgnore);
    }

    public SearchAlgorithm<RegionMatch> createSearchAlgorithm(opencv_core.IplImage inputImage) {
        opencv_core.IplImage queryGray = ImagePreprocessor.createGrayscale(this.getImage());
        return new SearchAlgorithmFactory.SearchWithIgnoreMask(inputImage, queryGray, this.createMask());
    }

    opencv_core.IplImage createMask() {
        BufferedImage queryImage = this.getImage();
        opencv_core.IplImage ignoreMask = opencv_core.IplImage.create(opencv_core.cvSize(queryImage.getWidth(), queryImage.getHeight()), 8, 1);
        opencv_core.cvSet(ignoreMask, opencv_core.cvScalarAll(0.0));
        for (BufferedImage subimage : this.subimagesToIgnore) {
            ImageSearcher searcher = new ImageSearcher(queryImage);
            ImageQuery query = new ImageQuery(subimage);
            List topMatches = searcher.search(query, null, 1);
            RegionMatch m = (RegionMatch)topMatches.get(0);
            opencv_core.cvRectangle(ignoreMask, opencv_core.cvPoint(m.getX(), m.getY()), opencv_core.cvPoint(m.getX() + m.getWidth(), m.getY() + m.getHeight()), opencv_core.cvScalarAll(255.0), -1, 8, 0);
        }
        logger.step(ignoreMask, (Object)"ignore mask");
        return ignoreMask;
    }
}

