/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.search;

import com.google.common.collect.Lists;
import com.googlecode.javacv.cpp.opencv_core;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.sikuli.core.cv.VisionUtils;
import org.sikuli.core.draw.PiccoloImageRenderer;
import org.sikuli.core.logging.ImageExplainer;
import org.sikuli.core.search.RegionMatch;
import org.sikuli.core.search.SearchAlgorithm;
import org.sikuli.core.search.TemplateMatchingUtilities;

public class SearchAlgorithmFactory {
    private static ImageExplainer logger = ImageExplainer.getExplainer(SearchAlgorithmFactory.class);

    static class SearchByGrayscaleAtOriginalResolution
    implements SearchAlgorithm<RegionMatch> {
        opencv_core.IplImage resultMatrix = null;
        opencv_core.IplImage query;
        opencv_core.IplImage input;

        SearchByGrayscaleAtOriginalResolution(opencv_core.IplImage input, opencv_core.IplImage query) {
            this.input = input;
            this.query = query;
        }

        @Override
        public void execute() {
            this.resultMatrix = TemplateMatchingUtilities.computeTemplateMatchResultMatrix(this.input, this.query);
        }

        @Override
        public RegionMatch fetchNext() {
            TemplateMatchingUtilities.TemplateMatchResult result = TemplateMatchingUtilities.fetchNextBestMatch(this.resultMatrix, this.query);
            RegionMatch m = new RegionMatch(result);
            m.setScore(result.score);
            return m;
        }
    }

    static class SearchWithIgnoreMask
    implements SearchAlgorithm<RegionMatch> {
        private static final int NUM_LOCAL_PATCHES = 4;
        private static final int NUM_VOTES_PER_PATCH = 3;
        private static final int VOTE_INCREMENT = 50;
        private RegionMatch bestMatch;
        private final opencv_core.IplImage ignoreMask;
        private final opencv_core.IplImage inputGray;
        private final opencv_core.IplImage queryGray;

        public SearchWithIgnoreMask(opencv_core.IplImage inputGray, opencv_core.IplImage queryGray, opencv_core.IplImage ignoreMask) {
            this.inputGray = inputGray;
            this.queryGray = queryGray;
            this.ignoreMask = ignoreMask;
        }

        @Override
        public void execute() {
            List<Rectangle> sampleRectangles = SearchWithIgnoreMask.sampleSalientLocalRectangles(this.queryGray, this.ignoreMask);
            opencv_core.IplImage voteMatrix = SearchWithIgnoreMask.vote(this.inputGray, this.queryGray, sampleRectangles);
            double[] min = new double[1];
            double[] max = new double[1];
            opencv_core.CvPoint minPoint = new opencv_core.CvPoint(2);
            opencv_core.CvPoint maxPoint = new opencv_core.CvPoint(2);
            opencv_core.cvMinMaxLoc((opencv_core.CvArr)voteMatrix, min, max, minPoint, maxPoint, null);
            final Rectangle b = new Rectangle(maxPoint.x(), maxPoint.y(), this.queryGray.width(), this.queryGray.height());
            PiccoloImageRenderer anno = new PiccoloImageRenderer(this.inputGray.getBufferedImage()){

                @Override
                protected void addContent(PLayer layer) {
                    PPath p = PPath.createRectangle(b.x, b.y, b.width, b.height);
                    p.setStroke(new BasicStroke(2.0f));
                    p.setStrokePaint(Color.red);
                    p.setPaint(null);
                    layer.addChild(p);
                }
            };
            if (max[0] < 4.0) {
                logger.step(anno.render(), (Object)"best location (not a match)");
            } else {
                logger.step(anno.render(), (Object)"best location");
            }
            double score = max[0] / 200.0;
            RegionMatch m = new RegionMatch(b);
            m.setScore(score);
        }

        private static opencv_core.IplImage vote(opencv_core.IplImage input, opencv_core.IplImage query, List<Rectangle> sampleRectangles) {
            final ArrayList<TemplateMatchingUtilities.TemplateMatchResult> ms = Lists.newArrayList();
            opencv_core.IplImage voteMatrix = opencv_core.IplImage.create(opencv_core.cvGetSize(input), 8, 1);
            opencv_core.cvSet(voteMatrix, opencv_core.cvScalarAll(0.0));
            for (Rectangle r : sampleRectangles) {
                opencv_core.IplImage featureImage = opencv_core.IplImage.create(opencv_core.cvSize(r.width, r.height), 8, 1);
                opencv_core.cvSetImageROI(query, opencv_core.cvRect(r.x, r.y, r.width, r.height));
                opencv_core.cvCopy(query, featureImage);
                opencv_core.IplImage rm = TemplateMatchingUtilities.computeTemplateMatchResultMatrix(input, featureImage);
                for (int i = 0; i < 3; ++i) {
                    TemplateMatchingUtilities.TemplateMatchResult b = TemplateMatchingUtilities.fetchNextBestMatch(rm, featureImage);
                    ms.add(b);
                    int ox = b.x - r.x;
                    int oy = b.y - r.y;
                    if (ox < 0 || oy < 0 || ox > voteMatrix.width() - 1 || oy > voteMatrix.height() - 1) continue;
                    opencv_core.CvScalar currentCount = opencv_core.cvGet2D(voteMatrix, oy, ox);
                    double val = currentCount.getVal(0);
                    opencv_core.cvSet2D(voteMatrix, oy, ox, opencv_core.cvScalarAll(val += 50.0));
                }
                opencv_core.cvResetImageROI(query);
            }
            PiccoloImageRenderer anno = new PiccoloImageRenderer(input.getBufferedImage()){

                @Override
                protected void addContent(PLayer layer) {
                    for (Rectangle m : ms) {
                        PPath p = PPath.createRectangle(m.x, m.y, m.width, m.height);
                        p.setStroke(new BasicStroke(2.0f));
                        p.setStrokePaint(Color.red);
                        p.setPaint(null);
                        layer.addChild(p);
                    }
                }
            };
            logger.step(anno.render(), (Object)"local features found in the input image");
            return voteMatrix;
        }

        private static List<Rectangle> sampleSalientLocalRectangles(opencv_core.IplImage gray, opencv_core.IplImage ignoreMask) {
            opencv_core.IplImage foreground = VisionUtils.computeForegroundMaskOf(gray);
            logger.step(foreground, (Object)"foreground");
            opencv_core.IplImage keepMask = opencv_core.IplImage.createCompatible(ignoreMask);
            opencv_core.cvNot(ignoreMask, keepMask);
            opencv_core.IplImage effectiveForeground = foreground;
            opencv_core.cvAnd(foreground, keepMask, effectiveForeground, null);
            logger.step(foreground, (Object)"effective foreground");
            opencv_core.IplImage block = opencv_core.IplImage.create(opencv_core.cvSize(25, 25), 8, 1);
            opencv_core.cvSet(block, opencv_core.cvScalarAll(255.0));
            opencv_core.IplImage resultMatrix = TemplateMatchingUtilities.computeTemplateMatchResultMatrix1(effectiveForeground, block);
            final ArrayList<Rectangle> rs = Lists.newArrayList();
            for (int i = 0; i < 4; ++i) {
                TemplateMatchingUtilities.TemplateMatchResult fetchNextBestMatch = TemplateMatchingUtilities.fetchNextBestMatch1(resultMatrix, block);
                rs.add(fetchNextBestMatch);
            }
            PiccoloImageRenderer anno = new PiccoloImageRenderer(gray.getBufferedImage()){

                @Override
                protected void addContent(PLayer layer) {
                    for (Rectangle m : rs) {
                        PPath p = PPath.createRectangle(m.x, m.y, m.width, m.height);
                        p.setStroke(new BasicStroke(2.0f));
                        p.setStrokePaint(Color.red);
                        p.setPaint(null);
                        layer.addChild(p);
                    }
                }
            };
            logger.step(anno.render(), (Object)"");
            return rs;
        }

        @Override
        public RegionMatch fetchNext() {
            return this.bestMatch;
        }
    }
}

