/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.search;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sikuli.core.search.Collector;
import org.sikuli.core.search.Filter;
import org.sikuli.core.search.Match;
import org.sikuli.core.search.Query;
import org.sikuli.core.search.SearchAlgorithm;
import org.sikuli.core.search.TopMatchesCollector;

public abstract class Searcher<T extends Match> {
    protected abstract SearchAlgorithm<T> getAlgorithm(Query var1);

    protected void explain(Query query, List<T> outputs) {
    }

    public List<T> search(Query query, Filter<T> filter, int n) {
        TopMatchesCollector results = new TopMatchesCollector(n);
        this.search(query, filter, results);
        return results.topMatches();
    }

    public List<T> search(Query query, Filter<T> filter, int n, SearchAlgorithm<T> alg) {
        TopMatchesCollector results = new TopMatchesCollector(n);
        this.search(query, filter, results, alg);
        return results.topMatches();
    }

    public List<T> search(Query query, int n) {
        TopMatchesCollector results = new TopMatchesCollector(n);
        this.search(query, null, results);
        return results.topMatches();
    }

    private void search(Query query, Filter<T> filter, Collector<T> collector) {
        this.search(query, filter, collector, this.getAlgorithm(query));
    }

    private void search(Query query, Filter<T> filter, Collector<T> collector, SearchAlgorithm<T> alg) {
        alg.execute();
        ArrayList<T> matches = Lists.newArrayList();
        while (!collector.hasEnough()) {
            T m = alg.fetchNext();
            if (filter == null || filter.accept(m)) {
                collector.collect(m);
                matches.add(m);
            }
            if (filter == null || filter.acceptMore(m)) continue;
            break;
        }
        this.explain(query, matches);
    }
}

