/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.search;

import com.googlecode.javacv.cpp.opencv_core;
import com.googlecode.javacv.cpp.opencv_imgproc;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import org.sikuli.core.logging.ImageExplainer;

public class TemplateMatchingUtilities {
    static ImageExplainer explainer = ImageExplainer.getExplainer(TemplateMatchingUtilities.class);

    public static opencv_core.IplImage computeTemplateMatchResultMatrix(opencv_core.IplImage input, opencv_core.IplImage target) {
        int iheight;
        int iwidth;
        if (input.roi() != null) {
            iwidth = input.roi().width() - target.width() + 1;
            iheight = input.roi().height() - target.height() + 1;
        } else {
            iwidth = input.width() - target.width() + 1;
            iheight = input.height() - target.height() + 1;
        }
        opencv_core.IplImage map = opencv_core.IplImage.create(opencv_core.cvSize(iwidth, iheight), 32, 1);
        opencv_imgproc.cvMatchTemplate(input, target, map, 5);
        return map;
    }

    static BufferedImage visualizeResultMatrix(opencv_core.IplImage result) {
        opencv_core.IplImage resultToShow = opencv_core.IplImage.create(opencv_core.cvGetSize(result), 8, 1);
        opencv_core.cvConvertScale(result, resultToShow, 255.0, 0.0);
        return resultToShow.getBufferedImage();
    }

    public static opencv_core.IplImage computeTemplateMatchResultMatrixWithMultipleROIs(opencv_core.IplImage input, opencv_core.IplImage target, List<Rectangle> ROIs) {
        opencv_core.cvResetImageROI(input);
        int iwidth = input.width() - target.width() + 1;
        int iheight = input.height() - target.height() + 1;
        opencv_core.IplImage result = opencv_core.IplImage.create(opencv_core.cvSize(iwidth, iheight), 32, 1);
        opencv_core.cvSet(result, opencv_core.cvScalarAll(0.0));
        for (Rectangle unboundedROI : ROIs) {
            if (unboundedROI.width < target.width() || unboundedROI.height < target.height()) continue;
            Rectangle roi = unboundedROI.intersection(new Rectangle(0, 0, input.width(), input.height()));
            opencv_core.cvSetImageROI(input, opencv_core.cvRect(roi.x, roi.y, roi.width, roi.height));
            int w = roi.width - target.width() + 1;
            int h = roi.height - target.height() + 1;
            opencv_core.cvSetImageROI(result, opencv_core.cvRect(roi.x, roi.y, w, h));
            opencv_imgproc.cvMatchTemplate(input, target, result, 5);
            opencv_core.cvResetImageROI(result);
            opencv_core.cvResetImageROI(input);
        }
        explainer.result(TemplateMatchingUtilities.visualizeResultMatrix(result), (Object)"result with faster implementation");
        return result;
    }

    public static opencv_core.IplImage computeTemplateMatchResultMatrixWithMultipleROIs_GrouthTruth(opencv_core.IplImage input, opencv_core.IplImage target, List<Rectangle> ROIs) {
        opencv_core.cvResetImageROI(input);
        int iwidth = input.width() - target.width() + 1;
        int iheight = input.height() - target.height() + 1;
        explainer.step(input, (Object)"input");
        opencv_core.IplImage result = opencv_core.IplImage.create(opencv_core.cvSize(iwidth, iheight), 32, 1);
        opencv_imgproc.cvMatchTemplate(input, target, result, 5);
        explainer.step(TemplateMatchingUtilities.visualizeResultMatrix(result), (Object)"raw result");
        opencv_core.IplImage keepMask = opencv_core.IplImage.create(opencv_core.cvSize(iwidth, iheight), 8, 1);
        opencv_core.cvSet(keepMask, opencv_core.cvScalarAll(0.0));
        for (Rectangle ROI : ROIs) {
            if (ROI.width < target.width() || ROI.height < target.height()) continue;
            int w = Math.min(ROI.width, iwidth - ROI.x);
            int h = Math.min(ROI.height, iheight - ROI.y);
            w = w - target.width() + 1;
            h = h - target.height() + 1;
            opencv_core.CvRect cvROI = opencv_core.cvRect(ROI.x, ROI.y, w, h);
            opencv_core.cvSetImageROI(keepMask, cvROI);
            opencv_core.cvSet(keepMask, opencv_core.cvScalarAll(255.0));
            opencv_core.cvResetImageROI(keepMask);
        }
        explainer.step(keepMask, (Object)"keep mask");
        opencv_core.IplImage maskedResult = opencv_core.IplImage.createCompatible(result);
        opencv_core.cvSet(maskedResult, opencv_core.cvScalarAll(0.0));
        opencv_core.cvCopy(result, maskedResult, keepMask);
        explainer.result(TemplateMatchingUtilities.visualizeResultMatrix(maskedResult), (Object)"match result with only ROIs");
        maskedResult.release();
        keepMask.release();
        return result;
    }

    public static opencv_core.IplImage computeTemplateMatchResultMatrix1(opencv_core.IplImage input, opencv_core.IplImage target) {
        int iheight;
        int iwidth;
        if (input.roi() != null) {
            iwidth = input.roi().width() - target.width() + 1;
            iheight = input.roi().height() - target.height() + 1;
        } else {
            iwidth = input.width() - target.width() + 1;
            iheight = input.height() - target.height() + 1;
        }
        opencv_core.IplImage map = opencv_core.IplImage.create(opencv_core.cvSize(iwidth, iheight), 32, 1);
        opencv_imgproc.cvMatchTemplate(input, target, map, 1);
        return map;
    }

    public static TemplateMatchResult fetchNextBestMatch1(opencv_core.IplImage resultMatrix, opencv_core.IplImage target) {
        double[] min = new double[1];
        double[] max = new double[1];
        opencv_core.CvPoint minPoint = new opencv_core.CvPoint(2);
        opencv_core.CvPoint maxPoint = new opencv_core.CvPoint(2);
        opencv_core.cvMinMaxLoc((opencv_core.CvArr)resultMatrix, min, max, minPoint, maxPoint, null);
        double detectionScore = min[0];
        opencv_core.CvPoint detectionLoc = minPoint;
        TemplateMatchResult r = new TemplateMatchResult();
        r.x = detectionLoc.x();
        r.y = detectionLoc.y();
        r.width = target.width();
        r.height = target.height();
        r.score = detectionScore;
        int xmargin = target.width() / 3;
        int ymargin = target.height() / 3;
        int x = detectionLoc.x();
        int y = detectionLoc.y();
        int x0 = Math.max(x - xmargin, 0);
        int y0 = Math.max(y - ymargin, 0);
        int x1 = Math.min(x + xmargin, resultMatrix.width());
        int y1 = Math.min(y + ymargin, resultMatrix.height());
        opencv_core.cvRectangle(resultMatrix, opencv_core.cvPoint(x0, y0), opencv_core.cvPoint(x1 - 1, y1 - 1), opencv_core.cvRealScalar(1.0), -1, 8, 0);
        return r;
    }

    public static TemplateMatchResult fetchNextBestMatch(opencv_core.IplImage resultMatrix, opencv_core.IplImage target) {
        double[] min = new double[1];
        double[] max = new double[1];
        opencv_core.CvPoint minPoint = new opencv_core.CvPoint(2);
        opencv_core.CvPoint maxPoint = new opencv_core.CvPoint(2);
        opencv_core.cvMinMaxLoc((opencv_core.CvArr)resultMatrix, min, max, minPoint, maxPoint, null);
        double detectionScore = max[0];
        opencv_core.CvPoint detectionLoc = maxPoint;
        TemplateMatchResult r = new TemplateMatchResult();
        r.x = detectionLoc.x();
        r.y = detectionLoc.y();
        r.width = target.width();
        r.height = target.height();
        r.score = detectionScore;
        int xmargin = target.width() / 3;
        int ymargin = target.height() / 3;
        int x = detectionLoc.x();
        int y = detectionLoc.y();
        int x0 = Math.max(x - xmargin, 0);
        int y0 = Math.max(y - ymargin, 0);
        int x1 = Math.min(x + xmargin, resultMatrix.width());
        int y1 = Math.min(y + ymargin, resultMatrix.height());
        opencv_core.cvRectangle(resultMatrix, opencv_core.cvPoint(x0, y0), opencv_core.cvPoint(x1 - 1, y1 - 1), opencv_core.cvRealScalar(0.0), -1, 8, 0);
        return r;
    }

    public static class TemplateMatchResult
    extends Rectangle {
        public double score;
    }
}

