/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.ocr;

import com.google.common.collect.Lists;
import com.jgoodies.looks.Fonts;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.sikuli.ocr.TextImageRenderer;

class FontLibrary {
    static List<Font> precreatedFonts = Lists.newArrayList();

    FontLibrary() {
    }

    private static List<Font> loadCustomFonts(String[] fontNames) {
        ArrayList<Font> fonts = Lists.newArrayList();
        for (String fontName : fontNames) {
            InputStream is = TextImageRenderer.class.getResourceAsStream(fontName);
            Font font = null;
            try {
                font = Font.createFont(0, is);
                fonts.add(font);
            }
            catch (FontFormatException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return fonts;
    }

    static List<Font> getFonts() {
        return precreatedFonts;
    }

    static {
        String[] fontNames = new String[]{};
        precreatedFonts = FontLibrary.loadCustomFonts(fontNames);
        precreatedFonts.add(Fonts.WINDOWS_XP_96DPI_DEFAULT_GUI);
        precreatedFonts.add(Fonts.WINDOWS_XP_120DPI_DEFAULT_GUI);
    }
}

