/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.recorder;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import org.json.simple.JSONObject;
import org.sikuli.recorder.EventWriter;
import org.sikuli.recorder.Utils;
import org.sikuli.recorder.event.ClickEvent;
import org.sikuli.recorder.event.Event;
import org.sikuli.recorder.event.ScreenShotEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventWriter
implements EventWriter {
    static Logger logger = LoggerFactory.getLogger(DefaultEventWriter.class);
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-SSS");
    private File outputDir;

    public static String getTimeStamp() {
        return sdf.format(new Date());
    }

    public DefaultEventWriter() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String name = sdf.format(new Date());
        try {
            File temp = Utils.createTempDirectory();
            this.outputDir = new File(temp, name);
            this.outputDir.mkdir();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void write(Event event) {
        if (event.getClass().equals(ScreenShotEvent.class)) {
            String name = DefaultEventWriter.getTimeStamp() + ".screenshot.png";
            BufferedImage image = ((ScreenShotEvent)event).getImage();
            try {
                ImageIO.write((RenderedImage)image, "png", new File(this.getEventDir(), name));
            }
            catch (IOException e) {
                // empty catch block
            }
            logger.trace("ScreenShot --> " + name);
        } else if (event.getClass().equals(ClickEvent.class)) {
            String name = DefaultEventWriter.getTimeStamp() + ".click.txt";
            JSONObject json = event.toJSON();
            try {
                Files.write(json.toJSONString(), new File(this.getEventDir(), name), Charsets.US_ASCII);
            }
            catch (IOException e) {
                // empty catch block
            }
            logger.debug(event + " --> " + name);
        }
    }

    public File getEventDir() {
        return this.outputDir;
    }

    public void setEventDir(File outputDir) {
        this.outputDir = outputDir;
    }
}

