/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.recorder;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jnativehook.GlobalScreen;
import org.jnativehook.NativeHookException;
import org.jnativehook.keyboard.NativeKeyEvent;
import org.jnativehook.keyboard.NativeKeyListener;
import org.sikuli.api.DesktopScreenRegion;
import org.sikuli.api.Relative;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.visual.Canvas;
import org.sikuli.api.visual.DesktopCanvas;
import org.sikuli.recorder.DefaultEventWriter;
import org.sikuli.recorder.detector.EventDetector;
import org.sikuli.recorder.detector.MouseEventDetector;
import org.sikuli.recorder.detector.ScreenshotEventDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recorder {
    static Logger logger = LoggerFactory.getLogger(Recorder.class);
    private Canvas canvas;
    private ScreenRegion regionOfInterest;
    private List<EventDetector> detectors = Lists.newArrayList();
    DefaultEventWriter writer = new DefaultEventWriter();
    CountDownLatch escapeSignal = new CountDownLatch(1);

    public Recorder() {
        MouseEventDetector d1 = new MouseEventDetector();
        ScreenshotEventDetector d2 = new ScreenshotEventDetector();
        this.canvas = new DesktopCanvas();
        this.addEventDetector(d1);
        this.addEventDetector(d2);
        this.setRegionOfInterest(new DesktopScreenRegion());
    }

    public File getEventDir() {
        return this.writer.getEventDir();
    }

    public void setEventDir(File dir) {
        this.writer.setEventDir(dir);
    }

    public void addEventDetector(EventDetector d) {
        d.setWriter(this.writer);
        this.detectors.add(d);
    }

    public void startRecording() {
        logger.info("Start Recording");
        for (EventDetector d : this.detectors) {
            d.start();
        }
    }

    public void setRegionOfInterest(ScreenRegion screenRegion) {
        this.regionOfInterest = screenRegion;
        for (EventDetector d : this.detectors) {
            d.setRegionOfInterest(screenRegion);
        }
    }

    public void stopRecording() {
        for (EventDetector d : this.detectors) {
            d.stop();
        }
    }

    public void start() {
        ScreenRegion outsideBorder = Relative.to(this.regionOfInterest).taller(7).wider(7).getScreenRegion();
        this.canvas.addBox(outsideBorder).withColor(Color.red).withLineWidth(3);
        this.canvas.show();
        try {
            GlobalScreen.registerNativeHook();
        }
        catch (NativeHookException ex) {
            System.err.println("There was a problem registering the native hook.");
            System.err.println(ex.getMessage());
            return;
        }
        GlobalScreen.getInstance().addNativeKeyListener(new HotKeyListener());
        try {
            this.escapeSignal.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.stopRecording();
        this.canvas.hide();
        System.out.println("Recording is stopped.");
    }

    class HotKeyListener
    implements NativeKeyListener {
        private Logger logger = LoggerFactory.getLogger(HotKeyListener.class);

        HotKeyListener() {
        }

        @Override
        public void nativeKeyPressed(NativeKeyEvent e) {
            boolean isCtrlPressed;
            boolean isMetaPressed = (e.getModifiers() & 4) > 0;
            boolean isAltPressed = (e.getModifiers() & 8) > 0;
            boolean isShiftPressed = (e.getModifiers() & 1) > 0;
            boolean bl = isCtrlPressed = (e.getModifiers() & 2) > 0;
            if (e.getKeyCode() == 50 && isShiftPressed && isCtrlPressed) {
                this.logger.trace("CTRL+SHIFT+2 is pressed");
                Recorder.this.startRecording();
            }
            if (e.getKeyCode() == 27 && isShiftPressed && isCtrlPressed) {
                this.logger.trace("CTRL+SHIFT+ESC is pressed");
                GlobalScreen.unregisterNativeHook();
                Recorder.this.escapeSignal.countDown();
            }
        }

        @Override
        public void nativeKeyReleased(NativeKeyEvent e) {
        }

        @Override
        public void nativeKeyTyped(NativeKeyEvent e) {
        }
    }
}

