/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.recorder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Zip {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipfile, File directory) throws IOException {
        ZipFile zfile = new ZipFile(zipfile);
        Enumeration<? extends ZipEntry> entries = zfile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File file = new File(directory, entry.getName());
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            file.getParentFile().mkdirs();
            InputStream in = zfile.getInputStream(entry);
            try {
                Zip.copy(in, file);
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipDir(File directory, File zipfile) throws IOException {
        URI base = directory.toURI();
        LinkedList<File> queue = new LinkedList<File>();
        queue.push(directory);
        FileOutputStream out = new FileOutputStream(zipfile);
        OutputStream res = out;
        try {
            ZipOutputStream zout = new ZipOutputStream(out);
            res = zout;
            while (!queue.isEmpty()) {
                directory = (File)queue.pop();
                for (File kid : directory.listFiles()) {
                    String name = base.relativize(kid.toURI()).getPath();
                    if (kid.isDirectory()) {
                        queue.push(kid);
                        name = name.endsWith("/") ? name : name + "/";
                        zout.putNextEntry(new ZipEntry(name));
                        continue;
                    }
                    zout.putNextEntry(new ZipEntry(name));
                    Zip.copy(kid, (OutputStream)zout);
                    zout.closeEntry();
                }
            }
        }
        finally {
            res.close();
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int readCount;
        byte[] buffer = new byte[1024];
        while ((readCount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, readCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File file, OutputStream out) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            Zip.copy((InputStream)in, out);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(InputStream in, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            Zip.copy(in, (OutputStream)out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }
}

