/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.recorder.detector;

import org.jnativehook.GlobalScreen;
import org.jnativehook.NativeHookException;
import org.jnativehook.mouse.NativeMouseEvent;
import org.jnativehook.mouse.NativeMouseInputListener;
import org.sikuli.api.ScreenRegion;
import org.sikuli.recorder.detector.EventDetector;
import org.sikuli.recorder.event.ClickEvent;

public class MouseEventDetector
extends EventDetector
implements NativeMouseInputListener {
    @Override
    public void nativeMouseClicked(NativeMouseEvent e) {
        ScreenRegion region = this.getRegionOfInterest();
        boolean isInsideROI = region.getBounds().contains(e.getX(), e.getY());
        if (isInsideROI) {
            ClickEvent event = new ClickEvent();
            event.setX(e.getX() - region.getBounds().x);
            event.setY(e.getY() - region.getBounds().y);
            event.setButton(e.getButton());
            event.setClickCount(e.getClickCount());
            this.eventDetected(event);
        }
    }

    @Override
    public void nativeMousePressed(NativeMouseEvent e) {
    }

    @Override
    public void nativeMouseReleased(NativeMouseEvent e) {
    }

    @Override
    public void nativeMouseMoved(NativeMouseEvent e) {
    }

    @Override
    public void nativeMouseDragged(NativeMouseEvent e) {
    }

    @Override
    public void start() {
        try {
            GlobalScreen.registerNativeHook();
        }
        catch (NativeHookException ex) {
            System.err.println("There was a problem registering the native hook.");
            System.err.println(ex.getMessage());
        }
        GlobalScreen.getInstance().addNativeMouseListener(this);
        GlobalScreen.getInstance().addNativeMouseMotionListener(this);
    }

    @Override
    public void stop() {
        GlobalScreen.getInstance().removeNativeMouseListener(this);
        GlobalScreen.getInstance().removeNativeMouseMotionListener(this);
    }
}

