/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.recorder.detector;

import java.awt.image.BufferedImage;
import org.sikuli.recorder.detector.EventDetector;
import org.sikuli.recorder.event.ScreenShotEvent;

public class ScreenshotEventDetector
extends EventDetector {
    volatile boolean running = true;
    private Thread capturingThread;

    @Override
    public void stop() {
        this.running = false;
        try {
            this.capturingThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void start() {
        this.capturingThread = new Thread(){

            @Override
            public void run() {
                while (ScreenshotEventDetector.this.running) {
                    ScreenshotEventDetector.this.running = true;
                    ScreenshotEventDetector.this.performScreenCapture();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this.capturingThread.start();
    }

    private void performScreenCapture() {
        BufferedImage image = this.getRegionOfInterest().capture();
        ScreenShotEvent e = new ScreenShotEvent();
        e.setImage(image);
        this.eventDetected(e);
    }
}

