/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.recorder.event;

import com.google.common.base.Objects;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.sikuli.recorder.event.Event;

public class ClickEvent
extends Event {
    private int x;
    private int y;
    private int button;
    private int clickCount;

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getButton() {
        return this.button;
    }

    public void setButton(int button) {
        this.button = button;
    }

    public int getCount() {
        return this.clickCount;
    }

    public void setClickCount(int count) {
        this.clickCount = count;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject obj = new JSONObject();
        obj.put("x", this.x);
        obj.put("y", this.y);
        obj.put("button", this.button);
        obj.put("clickCount", this.clickCount);
        return obj;
    }

    public static ClickEvent createFromJSON(String jsonText) {
        ClickEvent e = new ClickEvent();
        JSONParser parser = new JSONParser();
        try {
            Map json = (Map)parser.parse(jsonText);
            long x = (Long)json.get("x");
            long y = (Long)json.get("y");
            long button = (Long)json.get("button");
            long count = (Long)json.get("clickCount");
            e.setX((int)x);
            e.setY((int)y);
            e.setButton((int)button);
            e.setClickCount((int)count);
            return e;
        }
        catch (ParseException ep) {
            return null;
        }
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("x", this.x).add("y", this.y).add("button", this.button).add("clickCount", this.clickCount).toString();
    }
}

