/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.recorder.event;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sikuli.recorder.event.ClickEvent;
import org.sikuli.recorder.event.ClickEventGroup;
import org.sikuli.recorder.event.Event;
import org.sikuli.recorder.event.ScreenShotEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Events {
    private static Logger logger = LoggerFactory.getLogger(Events.class);

    public static List<Event> readEventsFrom(File inputDir) {
        ArrayList<Event> events = Lists.newArrayList();
        Object[] files = inputDir.listFiles();
        Arrays.sort(files);
        for (Object f : files) {
            String s = ((File)f).getPath();
            if (s.contains("click.txt")) {
                try {
                    String jsonString = Files.toString((File)f, Charsets.US_ASCII);
                    ClickEvent clickEvent = ClickEvent.createFromJSON(jsonString);
                    events.add(clickEvent);
                    logger.trace("read event:" + clickEvent);
                }
                catch (IOException e1) {}
                continue;
            }
            if (!s.contains("screenshot.png")) continue;
            ScreenShotEvent screenShotEvent = ScreenShotEvent.createFromFile((File)f);
            events.add(screenShotEvent);
        }
        return events;
    }

    public static List<ClickEventGroup> getClickEventGroups(List<Event> events) {
        ArrayList<ClickEventGroup> slideDataList = Lists.newArrayList();
        for (int i = 0; i < events.size(); ++i) {
            boolean isClickEventNext;
            Event e = events.get(i);
            if (!(e instanceof ClickEvent)) continue;
            ClickEvent clickEvent = (ClickEvent)e;
            ScreenShotEvent screenShotEventBefore = Events.findScreenShotEventBefore(events, i);
            boolean bl = isClickEventNext = i < events.size() - 1 && events.get(i + 1) instanceof ClickEvent;
            if (isClickEventNext || screenShotEventBefore == null) continue;
            ClickEventGroup data = new ClickEventGroup();
            data.setClickEvent(clickEvent);
            data.setScreenShotEventBefore(screenShotEventBefore);
            slideDataList.add(data);
        }
        return slideDataList;
    }

    private static ScreenShotEvent findScreenShotEventBefore(List<Event> events, int start) {
        for (int i = start; i >= 0; --i) {
            Event e = events.get(i);
            if (!(e instanceof ScreenShotEvent)) continue;
            return (ScreenShotEvent)e;
        }
        return null;
    }
}

