/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.recorder.html;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.sikuli.api.API;
import org.sikuli.recorder.event.ClickEvent;
import org.sikuli.recorder.event.ClickEventGroup;
import org.sikuli.recorder.event.Event;
import org.sikuli.recorder.event.Events;
import org.sikuli.recorder.event.ScreenShotEvent;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public class HTMLGenerator {
    static STGroup stg = new STGroupFile("org/sikuli/recorder/html/html.stg", "utf-8", '$', '$');

    public static void generate(File inputDir, File outputDir) {
        File imageDir;
        List<Event> events = Events.readEventsFrom(inputDir);
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        if (!(imageDir = new File(outputDir, "images")).exists()) {
            imageDir.mkdir();
        }
        ST pageListST = stg.getInstanceOf("page_list");
        ST indexST = stg.getInstanceOf("index");
        String firstPageUrl = null;
        int no = 1;
        List<ClickEventGroup> slideDataList = Events.getClickEventGroups(events);
        for (ClickEventGroup data : slideDataList) {
            ClickEvent clickEvent = data.getClickEvent();
            ScreenShotEvent screenShotEventBefore = data.getScreenShotEventBefore();
            try {
                File src = screenShotEventBefore.getFile();
                File dest = new File(imageDir, src.getName());
                Files.copy(src, dest);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            ST pageST = stg.getInstanceOf("page");
            pageST.add("x", clickEvent.getX() - 25);
            pageST.add("y", clickEvent.getY() - 25);
            pageST.add("xc", clickEvent.getX() - 5);
            pageST.add("yc", clickEvent.getY() - 5);
            pageST.add("imgurl", "images/" + screenShotEventBefore.getFile().getName());
            String command = "";
            if (clickEvent.getButton() == 1) {
                if (clickEvent.getCount() == 1) {
                    command = "Click";
                } else if (clickEvent.getCount() == 2) {
                    command = "Double Click";
                }
            } else if (clickEvent.getButton() == 3) {
                command = "Right Click";
            }
            pageST.add("command", command);
            String pageName = "" + no;
            String pageUrl = pageName + ".html";
            File outFile = new File(outputDir, pageUrl);
            try {
                Files.write(pageST.render(), outFile, Charsets.UTF_8);
            }
            catch (IOException e1) {
                // empty catch block
            }
            pageListST.addAggr("pages.{url,name}", new Object[]{pageUrl, pageName});
            if (firstPageUrl == null) {
                firstPageUrl = pageUrl;
                indexST.add("firstPageUrl", firstPageUrl);
            }
            ++no;
        }
        File indexFile = new File(outputDir, "index.html");
        File pageListFile = new File(outputDir, "page-list.html");
        try {
            Files.write(pageListST.render(), pageListFile, Charsets.UTF_8);
            Files.write(indexST.render(), indexFile, Charsets.UTF_8);
        }
        catch (IOException e1) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws MalformedURLException {
        File inputDir = new File("output/2013-06-06-15-14-21");
        File outputDir = new File("html");
        HTMLGenerator g = new HTMLGenerator();
        HTMLGenerator.generate(inputDir, outputDir);
        URI uri = new File(outputDir, "index.html").toURI();
        URL url = uri.toURL();
        API.browse(url);
    }
}

