/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sikuli.slides.api.Context;
import org.sikuli.slides.api.ExecutionEvent;
import org.sikuli.slides.api.SlideExecutionException;
import org.sikuli.slides.api.SlidesExecutor;
import org.sikuli.slides.api.actions.Action;
import org.sikuli.slides.api.actions.ActionExecutionException;
import org.sikuli.slides.api.actions.Actions;
import org.sikuli.slides.api.interpreters.DefaultInterpreter;
import org.sikuli.slides.api.models.Slide;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AutomationExecutor
implements SlidesExecutor {
    static Logger logger = LoggerFactory.getLogger(AutomationExecutor.class);
    private Context context;

    public AutomationExecutor(Context context) {
        this.context = context;
    }

    public AutomationExecutor() {
        this.context = new Context();
    }

    @Override
    public void execute(List<Slide> slides) throws SlideExecutionException {
        Action action;
        logger.info("Executing {} slide(s)", (Object)slides.size());
        DefaultInterpreter interpreter = new DefaultInterpreter();
        ArrayList<Action> actions = Lists.newArrayList();
        for (Slide slide : slides) {
            action = interpreter.interpret(slide);
            actions.add(action);
            logger.debug("Action interpreted: {}", (Object)action);
        }
        for (int i = 0; i < slides.size(); ++i) {
            Slide slide;
            slide = slides.get(i);
            action = (Action)actions.get(i);
            Context slideContext = new Context(this.context, slide);
            ExecutionEvent event = new ExecutionEvent(action, slideContext);
            if (!this.context.getExecutionFilter().accept(event)) {
                logger.info("Slide {} of {} is skipped", (Object)slide.getNumber(), (Object)slides.size());
                continue;
            }
            if (action == null) continue;
            logger.info("Slide {} of {}", (Object)slide.getNumber(), (Object)slides.size());
            logger.info(Actions.toPrettyString(action));
            try {
                action.execute(slideContext);
                continue;
            }
            catch (ActionExecutionException e) {
                SlideExecutionException ex = new SlideExecutionException(e);
                ex.setAction(e.getAction());
                ex.setSlide(slide);
                throw ex;
            }
        }
    }
}

