/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.sikuli.api.DesktopScreenRegion;
import org.sikuli.api.ScreenRegion;
import org.sikuli.slides.api.ExecutionFilter;
import org.sikuli.slides.api.ExecutionListener;
import org.sikuli.slides.api.listeners.ExecutionVisualizer;
import org.sikuli.slides.api.models.Slide;
import org.stringtemplate.v4.ST;

public class Context {
    private static final long DEFAULT_WAIT_TIME = 5000L;
    private static final float DEFAULT_MIN_SCORE = 0.7f;
    private ScreenRegion screenRegion;
    private Slide slide;
    private ExecutionListener executionListener = new ExecutionVisualizer();
    private ExecutionFilter filter = ExecutionFilter.Factory.createAllFilter();
    private Map<String, Object> parameters = Maps.newHashMap();
    private float minScore = 0.7f;
    private long waitTime = 5000L;

    public Context(ScreenRegion screenRegion) {
        this.screenRegion = Preconditions.checkNotNull(screenRegion);
    }

    public Context(Context context, Slide slide) {
        Preconditions.checkNotNull(context);
        this.copyFrom(context);
        this.slide = Preconditions.checkNotNull(slide);
    }

    public Context(Context context, ScreenRegion screenRegion) {
        this.copyFrom(context);
        this.screenRegion = screenRegion;
    }

    public Context() {
        this.screenRegion = new DesktopScreenRegion();
    }

    public Context(Context context) {
        Preconditions.checkNotNull(context);
        this.copyFrom(context);
    }

    private void copyFrom(Context copy) {
        this.setMinScore(copy.getMinScore());
        this.setScreenRegion(copy.getScreenRegion());
        this.setExecutionFilter(copy.getExecutionFilter());
        this.setExecutionListener(copy.getExecutionListener());
        this.setWaitTime(copy.getWaitTime());
        this.setSlide(copy.getSlide());
        this.parameters = Maps.newHashMap(copy.getParameters());
    }

    public ScreenRegion getScreenRegion() {
        return this.screenRegion;
    }

    public void setScreenRegion(ScreenRegion screenRegion) {
        this.screenRegion = Preconditions.checkNotNull(screenRegion);
    }

    public void addParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    public Map<String, Object> getParameters() {
        return Maps.newHashMap(this.parameters);
    }

    public String render(String templateText) {
        Preconditions.checkNotNull(templateText);
        ST st = new ST(templateText);
        for (Map.Entry<String, Object> e : this.parameters.entrySet()) {
            st.add(e.getKey(), e.getValue());
        }
        return st.render();
    }

    public ExecutionFilter getExecutionFilter() {
        return this.filter;
    }

    public void setExecutionFilter(ExecutionFilter filter) {
        this.filter = filter;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("minScore", this.minScore).add("parameter", this.parameters).add("screenRegion", this.screenRegion).toString();
    }

    public float getMinScore() {
        return this.minScore;
    }

    public void setMinScore(float minScore) {
        this.minScore = minScore;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    public ExecutionListener getExecutionListener() {
        return this.executionListener;
    }

    public void setExecutionListener(ExecutionListener executionListener) {
        this.executionListener = executionListener;
    }

    public Slide getSlide() {
        return this.slide;
    }

    public void setSlide(Slide slide) {
        this.slide = slide;
    }
}

