/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api;

import com.google.common.base.Preconditions;
import org.sikuli.slides.api.ExecutionEvent;
import org.sikuli.slides.api.actions.Action;
import org.sikuli.slides.api.actions.Actions;
import org.sikuli.slides.api.actions.BookmarkAction;
import org.sikuli.slides.api.models.Slide;

public interface ExecutionFilter {
    public boolean accept(ExecutionEvent var1);

    public static class Factory {
        private Factory() {
        }

        public static ExecutionFilter createSingleSlideFilter(final int number) {
            return new ExecutionFilter(){

                @Override
                public boolean accept(ExecutionEvent event) {
                    return event.getSlide().getNumber() == number;
                }
            };
        }

        public static ExecutionFilter createStartFromSlideFilter(final int number) {
            return new ExecutionFilter(){

                @Override
                public boolean accept(ExecutionEvent event) {
                    return event.getSlide().getNumber() >= number;
                }
            };
        }

        public static ExecutionFilter createRangeFilter(final int i, final int j) {
            return new ExecutionFilter(){

                @Override
                public boolean accept(ExecutionEvent event) {
                    Slide slide = event.getSlide();
                    return slide.getNumber() >= i && slide.getNumber() <= j;
                }
            };
        }

        public static ExecutionFilter createAllFilter() {
            return new ExecutionFilter(){

                @Override
                public boolean accept(ExecutionEvent event) {
                    return true;
                }
            };
        }

        public static ExecutionFilter createStartFromBookmarkFilter(String bookmarkName) {
            Preconditions.checkNotNull(bookmarkName);
            return new StartFromBookmarkFilter(bookmarkName);
        }

        static class StartFromBookmarkFilter
        implements ExecutionFilter {
            boolean isBookmarkFound = false;
            final String bookmarkName;

            public StartFromBookmarkFilter(String bookmarkName) {
                this.bookmarkName = bookmarkName;
            }

            @Override
            public boolean accept(ExecutionEvent slide) {
                if (this.isBookmarkFound) {
                    return true;
                }
                Action action = slide.getAction();
                BookmarkAction bookmarkAction = (BookmarkAction)Actions.select(action).isInstanceOf(BookmarkAction.class).first();
                if (bookmarkAction != null && bookmarkAction.getName().compareToIgnoreCase(this.bookmarkName) == 0) {
                    this.isBookmarkFound = true;
                    return true;
                }
                return false;
            }
        }
    }
}

