/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.sikuli.api.DesktopScreenRegion;
import org.sikuli.slides.api.AutomationExecutor;
import org.sikuli.slides.api.Context;
import org.sikuli.slides.api.SlideExecutionException;
import org.sikuli.slides.api.actions.Action;
import org.sikuli.slides.api.interpreters.DefaultInterpreter;
import org.sikuli.slides.api.io.PPTXSlidesReader;
import org.sikuli.slides.api.models.Slide;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slides {
    static Logger logger = LoggerFactory.getLogger(Slides.class);

    private Slides() {
    }

    public static void execute(URL url) throws SlideExecutionException {
        Preconditions.checkNotNull(url);
        DesktopScreenRegion screenRegion = new DesktopScreenRegion();
        Context context = new Context(screenRegion);
        Slides.execute(url, context);
    }

    public static void execute(URL url, Context context) throws SlideExecutionException {
        List<Slide> slides;
        Preconditions.checkNotNull(url);
        Preconditions.checkNotNull(context);
        logger.debug("execute slides with context {}", (Object)context);
        PPTXSlidesReader reader = new PPTXSlidesReader();
        try {
            slides = reader.read(url);
        }
        catch (IOException e) {
            throw new SlideExecutionException(e);
        }
        AutomationExecutor executor = new AutomationExecutor(context);
        executor.execute(slides);
    }

    public static void execute(File file) throws SlideExecutionException {
        Preconditions.checkNotNull(file);
        try {
            Slides.execute(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new SlideExecutionException(e);
        }
    }

    public static void execute(File file, Context context) throws SlideExecutionException {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(context);
        try {
            Slides.execute(file.toURI().toURL(), context);
        }
        catch (MalformedURLException e) {
            throw new SlideExecutionException(e);
        }
    }

    public static List<Action> interpret(File file) throws IOException {
        Preconditions.checkNotNull(file);
        DefaultInterpreter interpreter = new DefaultInterpreter();
        PPTXSlidesReader reader = new PPTXSlidesReader();
        List<Slide> slides = reader.read(file);
        ArrayList<Action> actions = Lists.newArrayList();
        for (Slide slide : slides) {
            Action action = interpreter.interpret(slide);
            actions.add(action);
            logger.info("Action interpreted: {}", (Object)action);
        }
        return actions;
    }
}

