/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.actions;

import com.google.common.collect.Lists;
import java.util.List;
import org.sikuli.slides.api.Context;
import org.sikuli.slides.api.ExecutionEvent;
import org.sikuli.slides.api.ExecutionListener;
import org.sikuli.slides.api.actions.Action;
import org.sikuli.slides.api.actions.ActionExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAction
implements Action {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private Action parent;
    private List<Action> actions = Lists.newArrayList();

    public void addChild(Action action) {
        this.actions.add(action);
        ((AbstractAction)action).setParent(this);
    }

    public void removeAllChildren() {
        for (Action action : this.actions) {
            ((AbstractAction)action).setParent(null);
        }
        this.actions.clear();
    }

    public Action getChild(int index) {
        if (index >= 0 && index < this.actions.size()) {
            return this.actions.get(index);
        }
        return null;
    }

    public Action hasChild(int index) {
        return this.actions.get(index);
    }

    public List<Action> getChildren() {
        return Lists.newArrayList(this.actions);
    }

    @Override
    public void execute(Context context) throws ActionExecutionException {
        ExecutionListener actionListener = context.getExecutionListener();
        if (actionListener != null) {
            actionListener.beforeExecution(new ExecutionEvent(this, context));
        }
        this.logger.debug("executing {}", (Object)this);
        try {
            this.doExecute(context);
        }
        catch (ActionExecutionException e) {
            throw e;
        }
        finally {
            if (actionListener != null) {
                actionListener.afterExecution(new ExecutionEvent(this, context));
            }
        }
    }

    protected abstract void doExecute(Context var1) throws ActionExecutionException;

    public Action getParent() {
        return this.parent;
    }

    public void setParent(Action parent) {
        this.parent = parent;
    }
}

