/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.actions;

import com.google.common.base.Objects;
import java.util.concurrent.TimeUnit;
import org.sikuli.slides.api.Context;
import org.sikuli.slides.api.actions.AbstractAction;

public class DelayAction
extends AbstractAction {
    private long duration;

    @Override
    protected void doExecute(Context context) {
        try {
            String waitMessage = "Execution will be delayed for " + this.duration + " milliseconds";
            this.logger.info(waitMessage);
            TimeUnit.MILLISECONDS.sleep(this.duration);
            this.logger.info("Waking up...");
        }
        catch (InterruptedException e) {
            this.logger.error("Error in wait operation:" + e.getMessage());
        }
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("duration", this.duration).toString();
    }
}

