/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.actions;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jnativehook.GlobalScreen;
import org.jnativehook.NativeHookException;
import org.jnativehook.keyboard.NativeKeyEvent;
import org.jnativehook.keyboard.NativeKeyListener;
import org.jnativehook.mouse.NativeMouseEvent;
import org.jnativehook.mouse.NativeMouseInputListener;
import org.sikuli.recorder.detector.EventDetector;
import org.sikuli.slides.api.actions.NativeMouseEventFilter;

class InputWaiter {
    private MouseEventDetector mouseDetector = new MouseEventDetector();
    private GlobalKeyListenerExample keyboardDetector = new GlobalKeyListenerExample();
    private CountDownLatch detectedSignal = new CountDownLatch(1);
    NativeMouseEventFilter filter;

    public void start(NativeMouseEventFilter filter) throws NativeHookException {
        this.filter = Preconditions.checkNotNull(filter);
        GlobalScreen.registerNativeHook();
        GlobalScreen.getInstance().addNativeKeyListener(this.keyboardDetector);
        GlobalScreen.getInstance().addNativeMouseMotionListener(this.mouseDetector);
        GlobalScreen.getInstance().addNativeMouseListener(this.mouseDetector);
        try {
            this.detectedSignal.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        GlobalScreen.getInstance().removeNativeMouseListener(this.mouseDetector);
        GlobalScreen.getInstance().removeNativeMouseMotionListener(this.mouseDetector);
        GlobalScreen.getInstance().removeNativeKeyListener(this.keyboardDetector);
        GlobalScreen.unregisterNativeHook();
    }

    void detected() {
        this.detectedSignal.countDown();
    }

    class MouseEventDetector
    extends EventDetector
    implements NativeMouseInputListener {
        MouseEventDetector() {
        }

        @Override
        public void nativeMouseClicked(NativeMouseEvent e) {
        }

        @Override
        public void nativeMousePressed(NativeMouseEvent e) {
        }

        @Override
        public void nativeMouseReleased(NativeMouseEvent e) {
        }

        @Override
        public void nativeMouseMoved(NativeMouseEvent e) {
            if (InputWaiter.this.filter.accept(e)) {
                InputWaiter.this.detected();
            }
        }

        @Override
        public void nativeMouseDragged(NativeMouseEvent e) {
        }
    }

    class GlobalKeyListenerExample
    implements NativeKeyListener {
        List<NativeKeyEvent> events = new ArrayList<NativeKeyEvent>();

        GlobalKeyListenerExample() {
        }

        @Override
        public void nativeKeyPressed(NativeKeyEvent e) {
        }

        @Override
        public void nativeKeyReleased(NativeKeyEvent e) {
        }

        @Override
        public void nativeKeyTyped(NativeKeyEvent e) {
        }
    }
}

