/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.actions;

import com.google.common.base.Objects;
import java.awt.Color;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.visual.Canvas;
import org.sikuli.api.visual.ScreenRegionCanvas;
import org.sikuli.slides.api.Context;
import org.sikuli.slides.api.actions.AbstractAction;

public class LabelAction
extends AbstractAction {
    private String text = "";
    private int fontSize = 12;
    private int duration = 3000;
    private Color backgroundColor = Color.yellow;

    @Override
    protected void doExecute(Context context) {
        ScreenRegion targetRegion = context.getScreenRegion();
        String textToDisplay = context.render(this.text);
        ScreenRegionCanvas canvas = new ScreenRegionCanvas(targetRegion);
        canvas.addLabel(targetRegion, textToDisplay).withColor(Color.black).withFontSize(this.fontSize).withLineWidth(2).withBackgroundColor(this.backgroundColor).withHorizontalAlignmentCenter().withVerticalAlignmentMiddle();
        ((Canvas)canvas).display(1.0 * (double)this.duration / 1000.0);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("text", this.text).toString();
    }
}

