/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.actions;

import com.google.common.base.Preconditions;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import org.jnativehook.mouse.NativeMouseEvent;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.robot.desktop.DesktopScreen;
import org.sikuli.slides.api.actions.NativeMouseEventFilter;

class OnScreenRegionClick
implements NativeMouseEventFilter {
    private ScreenRegion screenRegion;
    private int screenOffsetX;
    private int screenOffsetY;

    public OnScreenRegionClick(ScreenRegion screenRegion) {
        this.screenRegion = Preconditions.checkNotNull(screenRegion);
        int id = ((DesktopScreen)screenRegion.getScreen()).getScreenId();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = ge.getScreenDevices();
        Rectangle bounds = devices[id].getDefaultConfiguration().getBounds();
        this.screenOffsetX = bounds.x;
        this.screenOffsetY = bounds.y;
    }

    @Override
    public boolean accept(NativeMouseEvent event) {
        return this.inRange(event);
    }

    private boolean inRange(NativeMouseEvent e) {
        Rectangle r = this.screenRegion.getBounds();
        r.x += this.screenOffsetX;
        r.y += this.screenOffsetY;
        int x = e.getX();
        int y = e.getY();
        return r.contains(x, y);
    }
}

