/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.actions;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.sikuli.slides.api.Context;
import org.sikuli.slides.api.actions.AbstractAction;
import org.sikuli.slides.api.actions.Action;
import org.sikuli.slides.api.actions.ActionExecutionException;

public class ParallelAction
extends AbstractAction {
    private CountDownLatch doneSignal;

    @Override
    protected void doExecute(Context context) throws ActionExecutionException {
        int n = this.getChildren().size();
        this.doneSignal = new CountDownLatch(n);
        ArrayList<Worker> workers = Lists.newArrayList();
        for (Action action : this.getChildren()) {
            Context workerContxt = new Context(context);
            Worker worker = new Worker(action, workerContxt);
            workers.add(worker);
            new Thread(worker).start();
        }
        try {
            this.doneSignal.await();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (Worker worker : workers) {
            if (worker.success) continue;
            throw worker.exception;
        }
    }

    public String toString() {
        return Objects.toStringHelper(this).add("actions", this.getChildren()).toString();
    }

    class Worker
    implements Runnable {
        Action action;
        Context context;
        boolean success = true;
        ActionExecutionException exception = null;

        Worker(Action action, Context context) {
            this.action = action;
            this.context = context;
        }

        @Override
        public void run() {
            try {
                this.action.execute(this.context);
                this.success = true;
            }
            catch (ActionExecutionException e) {
                this.success = false;
                this.exception = e;
            }
            ParallelAction.this.doneSignal.countDown();
        }
    }
}

