/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.actions;

import com.google.common.base.Objects;
import org.sikuli.api.Relative;
import org.sikuli.api.ScreenRegion;
import org.sikuli.slides.api.Context;
import org.sikuli.slides.api.actions.AbstractAction;
import org.sikuli.slides.api.actions.Action;
import org.sikuli.slides.api.actions.ActionExecutionException;

public class RelativeAction
extends AbstractAction {
    private int x = 0;
    private int y = 0;
    private int width = 0;
    private int height = 0;
    private double xmin = 0.0;
    private double xmax = 1.0;
    private double ymin = 0.0;
    private double ymax = 1.0;
    private boolean isPixelUnit;

    public RelativeAction(int x, int y, int width, int height, Action targetAction) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.isPixelUnit = true;
        this.addChild(targetAction);
    }

    public RelativeAction(double xmin, double ymin, double xmax, double ymax, Action targetAction) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        this.isPixelUnit = false;
        this.addChild(targetAction);
    }

    @Override
    public void doExecute(Context context) throws ActionExecutionException {
        ScreenRegion screenRegion = context.getScreenRegion();
        ScreenRegion targetRegion = this.isPixelUnit ? Relative.to(screenRegion).region(this.x, this.y, this.width, this.height).getScreenRegion() : Relative.to(screenRegion).region(this.xmin, this.ymin, this.xmax, this.ymax).getScreenRegion();
        Context childConext = new Context(context, targetRegion);
        for (Action child : this.getChildren()) {
            child.execute(childConext);
        }
    }

    public String toString() {
        if (this.isPixelUnit) {
            return Objects.toStringHelper(this).add("x", this.x).add("y", this.y).add("width", this.width).add("height", this.height).add("children", this.getChildren()).toString();
        }
        return Objects.toStringHelper(this).add("x", String.format("(%.2f,%.2f)", this.xmin, this.xmax)).add("y", String.format("(%.2f,%.2f)", this.ymin, this.ymax)).add("children", this.getChildren()).toString();
    }
}

