/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.actions;

import com.google.common.base.Objects;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.api.visual.ScreenRegionCanvas;
import org.sikuli.slides.api.Context;
import org.sikuli.slides.api.actions.AbstractAction;
import org.sikuli.slides.api.actions.Action;
import org.sikuli.slides.api.actions.ActionExecutionException;

public class TargetAction
extends AbstractAction {
    private Target target;

    public TargetAction(Target target) {
        this.setTarget(target);
    }

    public TargetAction(Target target, Action targetAction) {
        this.setTarget(target);
        this.addChild(targetAction);
    }

    @Override
    protected void doExecute(Context context) throws ActionExecutionException {
        this.getTarget().setMinScore(context.getMinScore());
        long waitTime = context.getWaitTime();
        ScreenRegion screenRegion = context.getScreenRegion();
        ScreenRegion targetRegion = screenRegion.wait(this.getTarget(), (int)waitTime);
        if (targetRegion != null) {
            ScreenRegionCanvas canvas = new ScreenRegionCanvas(targetRegion);
            canvas.addBox(targetRegion);
            Context childConext = new Context(context, targetRegion);
            for (Action child : this.getChildren()) {
                child.execute(childConext);
            }
        } else {
            throw new ActionExecutionException("Unable to locate the target on the screen", this);
        }
    }

    public String toString() {
        return Objects.toStringHelper(this).add("target", this.getTarget()).toString();
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }
}

