/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.actions;

import com.google.common.base.Objects;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.slides.api.Context;
import org.sikuli.slides.api.actions.AbstractAction;
import org.sikuli.slides.api.actions.ActionExecutionException;

public class WaitAction
extends AbstractAction {
    private long duration = 10000L;
    private Target target;

    public WaitAction(Target target) {
        this.setTarget(target);
    }

    @Override
    protected void doExecute(Context context) throws ActionExecutionException {
        ScreenRegion screenRegion = context.getScreenRegion();
        ScreenRegion ret = screenRegion.wait(this.getTarget(), (int)this.duration);
        if (ret == null) {
            throw new ActionExecutionException("Unable to find the target after waiting for " + this.duration + " ms", this);
        }
    }

    public String toString() {
        return Objects.toStringHelper(this).add("target", this.getTarget()).toString();
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }
}

