/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.generators;

import java.io.File;
import org.sikuli.api.DesktopScreenRegion;
import org.sikuli.api.ImageTarget;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.robot.Keyboard;
import org.sikuli.api.robot.Mouse;
import org.sikuli.api.robot.desktop.DesktopKeyboard;
import org.sikuli.api.robot.desktop.DesktopMouse;

class GeneratedProgram {
    ScreenRegion screenRegion = new DesktopScreenRegion();
    Mouse mouse = new DesktopMouse();
    Keyboard keyboard = new DesktopKeyboard();
    public static int DEFAULT_WAIT_TIME = 5000;
    public static float DEFAULT_MINSCORE = 0.7f;
    public static String DEFAULT_IMAGE_DIRECTORY = "images";

    GeneratedProgram() {
    }

    public File findImageByName(String name) {
        return new File(DEFAULT_IMAGE_DIRECTORY + File.pathSeparator + name);
    }

    public boolean step1() {
        ImageTarget target = new ImageTarget(new File("image1.png"));
        target.setMinScore(DEFAULT_MINSCORE);
        ScreenRegion loc = this.screenRegion.find(target);
        if (loc != null) {
            this.mouse.click(loc.getCenter());
            return true;
        }
        return false;
    }

    public boolean step2() {
        ImageTarget target = new ImageTarget(new File("image2.png"));
        target.setMinScore(DEFAULT_MINSCORE);
        ScreenRegion loc = this.screenRegion.find(target);
        if (loc != null) {
            this.mouse.rightClick(loc.getCenter());
            return true;
        }
        return false;
    }

    public boolean step3() {
        ImageTarget target = new ImageTarget(new File("image3.png"));
        target.setMinScore(DEFAULT_MINSCORE);
        ScreenRegion loc = this.screenRegion.find(target);
        if (loc != null) {
            this.mouse.click(loc.getCenter());
            this.keyboard.type("something to type");
            return true;
        }
        return false;
    }

    public boolean step4() {
        return true;
    }

    public boolean step5() {
        ImageTarget target = new ImageTarget(new File("image5.png"));
        target.setMinScore(DEFAULT_MINSCORE);
        ScreenRegion loc = this.screenRegion.find(target);
        return loc != null;
    }

    public boolean step6() {
        ImageTarget target = new ImageTarget(new File("image6.png"));
        target.setMinScore(DEFAULT_MINSCORE);
        ScreenRegion loc = this.screenRegion.find(target);
        return loc == null;
    }

    public boolean step7() {
        ImageTarget target = new ImageTarget(new File("image7.png"));
        target.setMinScore(DEFAULT_MINSCORE);
        ScreenRegion loc = this.screenRegion.find(target);
        if (loc != null) {
            this.mouse.click(loc.getCenter());
            this.keyboard.type("something to type");
            return true;
        }
        return false;
    }

    public void executeAll() {
        boolean success1 = this.step1();
        boolean success2 = this.step2();
        boolean success3 = this.step3();
        boolean success4 = this.step4();
        boolean success5 = this.step5();
        boolean success6 = this.step6();
        boolean success7 = this.step7();
    }

    public static void main(String ... args) {
        GeneratedProgram prog = new GeneratedProgram();
        prog.executeAll();
    }
}

