/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.generators;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.sikuli.slides.api.actions.Action;
import org.sikuli.slides.api.actions.Actions;
import org.sikuli.slides.api.actions.DoubleClickAction;
import org.sikuli.slides.api.actions.ExistAction;
import org.sikuli.slides.api.actions.LeftClickAction;
import org.sikuli.slides.api.actions.NotExistAction;
import org.sikuli.slides.api.actions.RightClickAction;
import org.sikuli.slides.api.actions.TargetAction;
import org.sikuli.slides.api.actions.TypeAction;
import org.sikuli.slides.api.generators.CodeGenerator;
import org.sikuli.slides.api.sikuli.ContextImageTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

public class JavaAPICodeGenerator
implements CodeGenerator {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Images images;
    private String className;

    public JavaAPICodeGenerator(String className, File imageDir) {
        this.className = className;
        this.images = new Images(imageDir);
    }

    public Step generateStep(TargetAction targetAction, int number) {
        this.logger.debug("targetAction {}", (Object)targetAction);
        if (targetAction == null) {
            return null;
        }
        ContextImageTarget target = (ContextImageTarget)targetAction.getTarget();
        if (target == null) {
            return null;
        }
        BufferedImage targetImage = target.getTargetImage();
        if (targetImage == null) {
            return null;
        }
        File imageFile = this.images.addImage(targetImage, number);
        Action child = targetAction.getChild(0);
        if (child != null) {
            String actionName = "";
            String argument = "";
            if (child instanceof LeftClickAction) {
                actionName = "click";
            } else if (child instanceof RightClickAction) {
                actionName = "rightClick";
            } else if (child instanceof DoubleClickAction) {
                actionName = "doubleClick";
            } else if (child instanceof TypeAction) {
                actionName = "type";
                argument = ((TypeAction)child).getText();
            }
            Step step = new Step();
            step.type = "targetAction";
            step.number = number;
            step.filename = imageFile.getName();
            step.actionName = actionName;
            step.argument = argument;
            return step;
        }
        String type = "";
        if (targetAction instanceof ExistAction) {
            type = "exist";
        } else if (targetAction instanceof NotExistAction) {
            type = "notExist";
        }
        Step step = new Step();
        step.type = type;
        step.actionName = type;
        step.number = number;
        step.filename = imageFile.getName();
        return step;
    }

    @Override
    public boolean generate(List<Action> actions, OutputStream output) {
        ArrayList<Step> steps = Lists.newArrayList();
        int number = 1;
        for (Action action : actions) {
            TargetAction targetAction = (TargetAction)Actions.select(action).isInstanceOf(TargetAction.class).first();
            Step step = this.generateStep(targetAction, number);
            if (step != null) {
                steps.add(step);
            } else {
                step = new Step();
                step.type = "empty";
                step.actionName = action.getClass().getSimpleName();
                step.number = number;
                steps.add(step);
            }
            ++number;
        }
        STGroupFile g = new STGroupFile("org/sikuli/slides/api/generators/javaapi.stg", "utf-8", '$', '$');
        ST st = g.getInstanceOf("main");
        st.add("classname", this.className);
        st.add("imgdir", this.images.dir.getPath());
        st.add("list", steps);
        try {
            output.write(st.render().getBytes());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    static class Images {
        private File dir;

        public Images(File dir) {
            if (!dir.exists()) {
                dir.mkdir();
            }
            this.dir = dir;
        }

        public File addImage(BufferedImage image, int index) {
            File outFile = new File(this.dir, String.format("image%d.png", index));
            try {
                ImageIO.write((RenderedImage)image, "png", outFile);
                return outFile;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    static class Step {
        public int number;
        public String filename;
        public String actionName;
        public String argument;
        public String type;

        Step() {
        }
    }
}

