/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.interpreters;

import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.sikuli.api.Target;
import org.sikuli.slides.api.actions.AbstractAction;
import org.sikuli.slides.api.actions.Action;
import org.sikuli.slides.api.actions.BookmarkAction;
import org.sikuli.slides.api.actions.BrowserAction;
import org.sikuli.slides.api.actions.DelayAction;
import org.sikuli.slides.api.actions.DoubleClickAction;
import org.sikuli.slides.api.actions.DragAction;
import org.sikuli.slides.api.actions.DropAction;
import org.sikuli.slides.api.actions.ExistAction;
import org.sikuli.slides.api.actions.LabelAction;
import org.sikuli.slides.api.actions.LeftClickAction;
import org.sikuli.slides.api.actions.NotExistAction;
import org.sikuli.slides.api.actions.OptionalAction;
import org.sikuli.slides.api.actions.ParallelAction;
import org.sikuli.slides.api.actions.PauseAction;
import org.sikuli.slides.api.actions.RelativeAction;
import org.sikuli.slides.api.actions.RightClickAction;
import org.sikuli.slides.api.actions.SkipAction;
import org.sikuli.slides.api.actions.SlideAction;
import org.sikuli.slides.api.actions.TargetAction;
import org.sikuli.slides.api.actions.TypeAction;
import org.sikuli.slides.api.actions.WaitAction;
import org.sikuli.slides.api.interpreters.Interpreter;
import org.sikuli.slides.api.interpreters.KeywordDictionary;
import org.sikuli.slides.api.models.ImageElement;
import org.sikuli.slides.api.models.Slide;
import org.sikuli.slides.api.models.SlideElement;
import org.sikuli.slides.api.sikuli.ContextImageTarget;
import org.sikuli.slides.v1.utils.UnitConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInterpreter
implements Interpreter {
    Logger logger = LoggerFactory.getLogger(DefaultInterpreter.class);

    Action interpretAsClick(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.CLICK).first();
        if (keywordElement == null) {
            return null;
        }
        slide.remove(keywordElement);
        LeftClickAction action = new LeftClickAction();
        return this.interpretAsTargetAction(slide, action);
    }

    Action interpretAsRightClick(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.RIGHT_CLICK).first();
        if (keywordElement == null) {
            return null;
        }
        slide.remove(keywordElement);
        RightClickAction action = new RightClickAction();
        return this.interpretAsTargetAction(slide, action);
    }

    Action interpretAsDoubleClick(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.DOUBLE_CLICK).first();
        if (keywordElement == null) {
            return null;
        }
        slide.remove(keywordElement);
        DoubleClickAction action = new DoubleClickAction();
        return this.interpretAsTargetAction(slide, action);
    }

    Action interpretAsDrag(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.DRAG).first();
        if (keywordElement == null) {
            return null;
        }
        slide.remove(keywordElement);
        DragAction action = new DragAction();
        return this.interpretAsTargetAction(slide, action);
    }

    Action interpretAsDrop(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.DROP).first();
        if (keywordElement == null) {
            return null;
        }
        slide.remove(keywordElement);
        DropAction action = new DropAction();
        return this.interpretAsTargetAction(slide, action);
    }

    Action interpretAsExist(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.EXIST).first();
        if (keywordElement == null) {
            return null;
        }
        Target target = this.interpretAsImageTarget(slide);
        if (target == null) {
            return null;
        }
        return new ExistAction(target);
    }

    Action interpretAsNotExist(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.NOT_EXIST).first();
        if (keywordElement == null) {
            return null;
        }
        Target target = this.interpretAsImageTarget(slide);
        if (target == null) {
            return null;
        }
        return new NotExistAction(target);
    }

    Action interpretAsLabel(Slide slide, SlideElement textElement) {
        LabelAction action = new LabelAction();
        action.setText(textElement.getText());
        double fontSize = UnitConverter.WholePointsToPoints(textElement.getTextSize());
        action.setFontSize((int)fontSize);
        try {
            Color bgColor = Color.decode("#" + textElement.getBackgroundColor());
            action.setBackgroundColor(bgColor);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        SlideElement targetElement = slide.select().isTarget().near(textElement, 200000).first();
        if (targetElement == null) {
            double xmin = 1.0 * (double)textElement.getOffx() / 9144000.0;
            double ymin = 1.0 * (double)textElement.getOffy() / 6858000.0;
            double xmax = 1.0 * (double)(textElement.getOffx() + textElement.getCx()) / 9144000.0;
            double ymax = 1.0 * (double)(textElement.getOffy() + textElement.getCy()) / 6858000.0;
            RelativeAction relativeAction = new RelativeAction(xmin, ymin, xmax, ymax, (Action)action);
            return relativeAction;
        }
        Target imageTarget = this.interpretAsImageTarget(slide, targetElement);
        int offsetX = UnitConverter.emuToPixels(textElement.getOffx() - targetElement.getOffx());
        int offsetY = UnitConverter.emuToPixels(textElement.getOffy() - targetElement.getOffy());
        int width = UnitConverter.emuToPixels(textElement.getCx());
        int height = UnitConverter.emuToPixels(textElement.getCy());
        RelativeAction relativeAction = new RelativeAction(offsetX, offsetY, width, height, (Action)action);
        TargetAction targetAction = new TargetAction(imageTarget, relativeAction);
        return targetAction;
    }

    Action interpretAsLabel(Slide slide) {
        List<SlideElement> textElements = slide.select().isNotKeyword().hasText().all();
        if (textElements.size() == 0) {
            return null;
        }
        if (textElements.size() == 1) {
            return this.interpretAsLabel(slide, textElements.get(0));
        }
        ParallelAction pa = new ParallelAction();
        for (SlideElement textElement : textElements) {
            Action labelAction = this.interpretAsLabel(slide, textElement);
            pa.addChild(labelAction);
        }
        return pa;
    }

    Target createTarget(ImageElement imageElement, SlideElement targetElement) {
        if (imageElement == null || targetElement == null) {
            return null;
        }
        int w = imageElement.getCx();
        int h = imageElement.getCy();
        if (w <= 0 || h <= 0) {
            return null;
        }
        double xmax = 1.0 * (double)(targetElement.getOffx() + targetElement.getCx() - imageElement.getOffx()) / (double)w;
        double ymax = 1.0 * (double)(targetElement.getOffy() + targetElement.getCy() - imageElement.getOffy()) / (double)h;
        double xmin = 1.0 * (double)(targetElement.getOffx() - imageElement.getOffx()) / (double)w;
        double ymin = 1.0 * (double)(targetElement.getOffy() - imageElement.getOffy()) / (double)h;
        xmax = Math.min(1.0, xmax);
        ymax = Math.min(1.0, ymax);
        xmin = Math.max(0.0, xmin);
        ymin = Math.max(0.0, ymin);
        return new ContextImageTarget(imageElement.getSource(), xmin, ymin, xmax, ymax);
    }

    Target interpretAsImageTarget(Slide slide) {
        SlideElement targetElement = slide.select().isTarget().first();
        if (targetElement == null) {
            return null;
        }
        return this.interpretAsImageTarget(slide, targetElement);
    }

    Target interpretAsImageTarget(Slide slide, SlideElement targetElement) {
        ImageElement imageElement = (ImageElement)slide.select().intersects(targetElement).isImage().first();
        if (imageElement == null) {
            return null;
        }
        Target target = this.createTarget(imageElement, targetElement);
        if (target == null) {
            return null;
        }
        return target;
    }

    Action interpretAsTargetAction(Slide slide, Action doAction) {
        Target target = this.interpretAsImageTarget(slide);
        if (target == null) {
            return doAction;
        }
        return new TargetAction(target, doAction);
    }

    Action interpretAsType(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.TYPE).first();
        if (keywordElement == null) {
            return null;
        }
        SlideElement textElement = slide.select().hasText().first();
        if (textElement == null) {
            return null;
        }
        TypeAction typeAction = new TypeAction();
        typeAction.setText(textElement.getText());
        slide.remove(keywordElement);
        slide.remove(textElement);
        return this.interpretAsTargetAction(slide, typeAction);
    }

    Action interpretAsBrowser(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.BROWSER).first();
        if (keywordElement == null) {
            return null;
        }
        SlideElement textElement = slide.select().hasText().first();
        if (textElement == null) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(textElement.getText());
        }
        catch (MalformedURLException e) {
            return null;
        }
        slide.remove(keywordElement);
        slide.remove(textElement);
        BrowserAction a = new BrowserAction();
        a.setUrl(url);
        return a;
    }

    Long interpretAsDuration(SlideElement textElement) {
        String waitTimeString;
        String arg = textElement.getText();
        TimeUnit timeUnit = UnitConverter.extractTimeUnitFromString(arg);
        if (timeUnit == null) {
            timeUnit = TimeUnit.SECONDS;
        }
        if ((waitTimeString = arg.replaceAll("[^0-9.]", "")) != null) {
            double duration = Double.parseDouble(waitTimeString);
            Double durationInMilliSeconds = 0.0;
            if (timeUnit == TimeUnit.SECONDS) {
                durationInMilliSeconds = duration * 1000.0;
            } else if (timeUnit == TimeUnit.MINUTES) {
                durationInMilliSeconds = duration * 1000.0 * 60.0;
            } else if (timeUnit == TimeUnit.HOURS) {
                durationInMilliSeconds = duration * 1000.0 * 60.0 * 60.0;
            }
            return durationInMilliSeconds.longValue();
        }
        this.logger.error("Error: Please write a valid time string. Valid examples include: 10 milliseconds, 10 seconds, 10 minutes.");
        return null;
    }

    Action interpretAsDelay(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.DELAY).first();
        if (keywordElement == null) {
            return null;
        }
        SlideElement textElement = slide.select().hasText().first();
        if (textElement == null) {
            return null;
        }
        Long duration = this.interpretAsDuration(textElement);
        if (duration == null) {
            return null;
        }
        slide.remove(keywordElement);
        slide.remove(textElement);
        DelayAction a = new DelayAction();
        a.setDuration(duration);
        return a;
    }

    Action interpretAsWait(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.WAIT).first();
        if (keywordElement == null) {
            return null;
        }
        Target target = this.interpretAsImageTarget(slide);
        if (target == null) {
            return null;
        }
        SlideElement textElement = slide.select().hasText().first();
        if (textElement == null) {
            return null;
        }
        Long duration = this.interpretAsDuration(textElement);
        if (duration == null) {
            return null;
        }
        slide.remove(keywordElement);
        slide.remove(textElement);
        WaitAction a = new WaitAction(target);
        a.setDuration(duration);
        return a;
    }

    private Action interpretAsSkip(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.SKIP).first();
        if (keywordElement == null) {
            return null;
        }
        slide.remove(keywordElement);
        return new SkipAction();
    }

    private Action interpretAsOptional(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.OPTIONAL).first();
        if (keywordElement == null) {
            return null;
        }
        slide.remove(keywordElement);
        return new OptionalAction();
    }

    private Action interpretAsPause(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.PAUSE).first();
        if (keywordElement == null) {
            return null;
        }
        slide.remove(keywordElement);
        return new PauseAction();
    }

    private Action interpretAsBookmark(Slide slide) {
        SlideElement keywordElement = slide.select().isKeyword(KeywordDictionary.BOOKMARK).first();
        if (keywordElement == null) {
            return null;
        }
        String text = keywordElement.getText();
        if (text.isEmpty()) {
            this.logger.error("No name is specified for the bookmark keyword");
            return null;
        }
        slide.remove(keywordElement);
        BookmarkAction action = new BookmarkAction();
        action.setName(text);
        return action;
    }

    @Override
    public Action interpret(Slide inputSlide) {
        Action labelAction;
        Slide slide = new Slide(inputSlide);
        Action keywordAction = null;
        keywordAction = this.interpretAsClick(slide);
        if (keywordAction != null || (keywordAction = this.interpretAsExist(slide)) != null || (keywordAction = this.interpretAsRightClick(slide)) != null || (keywordAction = this.interpretAsDoubleClick(slide)) != null || (keywordAction = this.interpretAsDoubleClick(slide)) != null || (keywordAction = this.interpretAsDrag(slide)) != null || (keywordAction = this.interpretAsDrop(slide)) != null || (keywordAction = this.interpretAsBrowser(slide)) != null || (keywordAction = this.interpretAsNotExist(slide)) != null || (keywordAction = this.interpretAsDelay(slide)) != null || (keywordAction = this.interpretAsWait(slide)) != null || (keywordAction = this.interpretAsType(slide)) != null) {
            // empty if block
        }
        Action action = null;
        ParallelAction parallelAction = new ParallelAction();
        if (keywordAction != null) {
            parallelAction.addChild(keywordAction);
        }
        if ((labelAction = this.interpretAsLabel(slide)) != null) {
            parallelAction.addChild(labelAction);
        }
        action = parallelAction;
        Action controlAction = null;
        controlAction = this.interpretAsSkip(slide);
        if (controlAction != null || (controlAction = this.interpretAsOptional(slide)) != null || (controlAction = this.interpretAsPause(slide)) != null || (controlAction = this.interpretAsBookmark(slide)) != null) {
            // empty if block
        }
        if (controlAction != null) {
            ((AbstractAction)controlAction).addChild(action);
            action = controlAction;
        }
        SlideAction slideAction = new SlideAction();
        if (action != null) {
            slideAction.addChild(action);
        }
        return slideAction;
    }
}

