/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.interpreters;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;

public class Keyword {
    private String name;
    private Type type;
    private List<String> aliases = Lists.newArrayList();

    Keyword(String name) {
        this.setName(name);
    }

    boolean isMatched(String textToMatch) {
        return this.match(textToMatch) != null;
    }

    public String match(String textToMatch) {
        if (textToMatch == null) {
            return null;
        }
        if (textToMatch.toLowerCase().startsWith(this.getName().toLowerCase())) {
            return textToMatch.substring(0, this.getName().length());
        }
        for (String alias : this.aliases) {
            if (!textToMatch.toLowerCase().startsWith(alias.toLowerCase())) continue;
            return textToMatch.substring(0, alias.length());
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    static Builder word(String name) {
        return new Builder(name);
    }

    public String toString() {
        return Objects.toStringHelper("Keyword").add("name", this.name).add("aliases", this.aliases).toString();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    static class Builder {
        private Keyword word;

        Builder(String name) {
            this.word = new Keyword(name);
        }

        Builder addAlias(String alias) {
            this.word.aliases.add(alias);
            return this;
        }

        Builder type(Type type) {
            this.word.type = type;
            return this;
        }

        Keyword build() {
            return this.word;
        }
    }

    static enum Type {
        ACTION,
        CONTROL;

    }
}

