/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.slides.api.interpreters;

import org.sikuli.slides.api.interpreters.Keyword;

public class KeywordDictionary {
    static final Keyword CLICK = Keyword.word("click").type(Keyword.Type.ACTION).addAlias("leftclick").addAlias("left-click").build();
    static final Keyword RIGHT_CLICK = Keyword.word("Right Click").type(Keyword.Type.ACTION).addAlias("right-click").addAlias("rightclick").build();
    static final Keyword DOUBLE_CLICK = Keyword.word("Double Click").type(Keyword.Type.ACTION).addAlias("double-click").addAlias("doubleclick").build();
    static final Keyword TYPE = Keyword.word("Type").type(Keyword.Type.ACTION).build();
    static final Keyword DRAG = Keyword.word("Drag").type(Keyword.Type.ACTION).build();
    static final Keyword DROP = Keyword.word("Drop").type(Keyword.Type.ACTION).build();
    static final Keyword BROWSER = Keyword.word("Browser").type(Keyword.Type.ACTION).addAlias("browse").build();
    static final Keyword NOT_EXIST = Keyword.word("Not Exist").type(Keyword.Type.ACTION).build();
    static final Keyword EXIST = Keyword.word("Exist").type(Keyword.Type.ACTION).build();
    static final Keyword DELAY = Keyword.word("Delay").type(Keyword.Type.ACTION).addAlias("sleep").build();
    static final Keyword WAIT = Keyword.word("Wait").type(Keyword.Type.ACTION).build();
    static final Keyword SKIP = Keyword.word("Skip").type(Keyword.Type.CONTROL).build();
    static final Keyword OPTIONAL = Keyword.word("Optional").type(Keyword.Type.CONTROL).build();
    static final Keyword BOOKMARK = Keyword.word("Bookmark").type(Keyword.Type.CONTROL).build();
    static final Keyword PAUSE = Keyword.word("pause").type(Keyword.Type.ACTION).build();
    static final Keyword[] WORDS = new Keyword[]{CLICK, RIGHT_CLICK, DOUBLE_CLICK, TYPE, DRAG, DROP, BROWSER, NOT_EXIST, EXIST, DELAY, WAIT, SKIP, OPTIONAL, BOOKMARK, PAUSE};

    public static final Keyword lookup(String name) {
        for (Keyword word : WORDS) {
            if (!word.isMatched(name)) continue;
            return word;
        }
        return null;
    }
}

